#include "FileContainer.h"
#include "FileImage.h"
#include "c64file.h"
#include "d64.h"
#include "files.h"
#include "petscii.h"
#include "FilePRG.h"
#include "FileP00.h"
#include "FileT64.h"
#include "FileLNX.h"

FileContainer::FileContainer()
{
	Path = 0;
	Header = 0;
	Entries = 0;
	Count = 0;
}

FileContainer::FileContainer(SP<class StringStream> path)
{
	Path = path;
	Header = 0;
	Entries = 0;
	Count = 0;
}

FileContainer::~FileContainer()
{
	int i;

	if (Path != 0) Path = 0;
	if (Header != 0) Header = 0;

	if (Entries != 0) {
		for (i=0;i<Count;i++) {
			if (Entries[i] != 0) {
				delete Entries[i];
			}
		}
		delete[] Entries;
		Entries = 0;
	}
}

void FileContainer::SetHeader(SP<class ByteBuffer> head)
{
	Header = head;
}

SP<ByteBuffer> FileContainer::GetHeader(void)
{
	return (Header);
}

SP<StringStream> FileContainer::GetPath(void)
{
	return (Path);
}

void FileContainer::Add(class C64File *file)
{
	int i;
	class C64File **ne;

	if (file == 0) return;

	ne = new C64File*[Count+1];

	if (Entries != 0) {
		for (i=0;i<Count;i++) ne[i] = Entries[i];
		delete[] Entries;
	}

	Entries = ne;
	Entries[Count] = file;
	Count++;
}

bool FileContainer::AddTo(class FileImage *img)
{
	int i;
	bool ok;
	class C64File *entry;

	ok = true;
	for (i=0;i<Count;i++) {
		entry = Entries[i];
		if (entry) {
			ok &= img->WriteFile(entry);
		}
		if (!ok) break;
	}

	if (img->GetPath() == 0) {
		if (Path != 0) img->SetPath(getfilename(newextension(Path, ".d64")));
		if (Header != 0) img->SetHeader(Header);
	}

	return (ok);
}

class FileContainer *ParseFile(SP<StringStream> path, int type, const unsigned char *data, int size)
{
	class FileContainer *fc;

	fc = 0;
	switch (type)
	{
	default:
		fc = ParsePRG(path, 0x00, data, size);
		break;
	case (FILETYPE_PRG):
		fc = ParsePRG(path, 0x82, data, size);
		break;
	case (FILETYPE_SEQ):
		fc = ParsePRG(path, 0x81, data, size);
		break;
	case (FILETYPE_USR):
		fc = ParsePRG(path, 0x83, data, size);
		break;
	case (FILETYPE_P00):
		fc = ParseP00(path, 0x82, data, size);
		break;
	case (FILETYPE_S00):
		fc = ParseP00(path, 0x81, data, size);
		break;
	case (FILETYPE_U00):
		fc = ParseP00(path, 0x83, data, size);
		break;
	case (FILETYPE_T64):
		fc = ParseT64(path, data, size);
		break;
	case (FILETYPE_LNX):
		fc = ParseLNX(path, data, size);
		break;
	};

	return (fc);
}
