#include "FileImage.h"
#include "StringStream.h"
#include "ByteBuffer.h"
#include "d64.h"
#include "atr.h"
#include "stringops.h"
#include "debug.h"
#include "files.h"
#include <stdlib.h>
#include <stdio.h>

void FileImage::DebugPrint(const char *str)
{
#ifdef _DEBUG
	sDPrintF("%s\n", str);
	if (Path != 0) {
		sDPrintF("\"%s\"\n", Path->GetString());
	} else {
		sDPrintF("<NULL>\n");
	}
	sDPrintF("%i, %02x, %08x, %i, %i, %i\n", Type, Flags, Image, Size, Tracks, TotalSectors);
#endif
}

FileImage::FileImage(void)
{
	Path = 0;
	Type = IMAGETYPE_NULL;
	Flags = IMAGEFLAG_NEW;
	Image = 0;
	Size = 0;
	Tracks = 0;
	TotalSectors = 0;

#ifdef _DEBUG
	DebugPrint("FileImage(void);");
#endif
}

FileImage::~FileImage(void)
{
#ifdef _DEBUG
	DebugPrint("~FileImage(void);");
#endif

	Path = 0;
	if (Image != 0) delete[] Image;
}

void FileImage::SetPath(SP<StringStream> p)
{
	if (Path != 0) {
		Path = 0;
	}

	if (p != 0) Path = p;
}

SP<StringStream> FileImage::GetPath(void)
{
	return (Path);
}

int FileImage::GetType(void)
{
	return (Type);
}

int FileImage::GetImageSystem(void)
{
	return (IMAGESYSTEM_NULL);
}

void FileImage::SetHeader(SP<ByteBuffer> header)
{
}

bool FileImage::HasHeader(void)
{
	return false;
}

void FileImage::Save(const char *filename)
{
}

void FileImage::Validate(void)
{
}

bool FileImage::WriteFile(C64File *file)
{
	return false;
}

bool FileImage::AddSeperator(void)
{
	return false;
}

void FileImage::ScratchFile(unsigned long index) {}

struct CbmList *FileImage::GetDirectory(void)
{
	return 0;
}

SP<StringStream> FileImage::SaveFile(SP<StringStream> temppath, unsigned long index)
{
	return 0;
}

C64File *FileImage::GetFile(unsigned long index)
{
	return 0;
}

void FileImage::TestDirectory(void) {}

SP<StringStream> FileImage::GetInfoText(void)
{
	SP<StringStream> str;
	int count;

	str = new StringStream((char*)0);
	if (GetPath() == 0) return (str);
	TestDirectory();

	str = new StringStream(GetPath());
	if (Flags & (IMAGEFLAG_INVALID_BAM | IMAGEFLAG_LOOPED_DIR | IMAGEFLAG_CORRUPT_DIRLINK))
	{
		count = 0;
		if (Flags & IMAGEFLAG_INVALID_BAM) {
			if (count == 0) str = str->Append(" (");
			else str = str->Append(", ");
			str = str->Append("invalid BAM");
			count++;
		}
		if (Flags & IMAGEFLAG_LOOPED_DIR) {
			if (count == 0) str = str->Append(" (");
			else str = str->Append(", ");
			str = str->Append("looped Directory");
			count++;
		}
		if (Flags & IMAGEFLAG_CORRUPT_DIRLINK) {
			if (count == 0) str = str->Append(" (");
			else str = str->Append(", ");
			str = str->Append("corrupt Directory linking");
			count++;
		}
		if (count > 0) str = str->Append(")");
	}

	return (str);
}

unsigned char *FileImage::GetDirEntry(unsigned long index)
{
	return 0;
}

unsigned char *FileImage::GetHeader(void)
{
	return 0;
}

void FileImage::SwapDirEntries(unsigned long index1, unsigned long index2)
{
}

class FileImage *FileImage::Clone(void)
{
	return (0);
}

bool FileImage::IsEqual(class FileImage *img)
{
	int i;

	if ((img == 0) || (this == 0)) {
		return (this == img);
	}

	if (Type != img->Type) return false;
	if (Size != img->Size) return false;
	if (Tracks != img->Tracks) return false;
	if (TotalSectors != img->TotalSectors) return false;

	for (i=0;i<Size;i++) {
		if (Image[i] != img->Image[i]) return false;
	}

	return (true);
}

bool FileImage::Exists(void)
{
	return (FileExists(Path));
}

/***************************************************************************************************/

class FileImage *CreateImage(SP<class StringStream> path, int type, const unsigned char *data, int size)
{
	class FileImage *img;

	img = 0;
	switch (type)
	{
	case (FILETYPE_ATR):
	case (FILETYPE_XFD):
		img = CreateATR(path, type, data, size);
		break;

	case FILETYPE_D64:
	case FILETYPE_ZIP:
		img = CreateD64(path, type, data, size);
		break;

	case FILETYPE_DCM:
	default:
		break;
	}

	return (img);
}

class FileImage *CreateImage(const char *path)
{
	FILE *f;
	long size;
	FileImage *img;
	SP<StringStream> spath;
	unsigned char *data;

	img = 0;

	f = fopen(path, "rb");
	if (f) {
		fseek(f, 0, SEEK_END);
		size = ftell(f);
		fseek(f, 0, SEEK_SET);
		data = 0;
		if (size <= 2*1024*1024) {
			data = new unsigned char[size];
			if (size > 0) {
				size = fread((void *)data, 1, size, f);
			}
		}
		fclose(f);

		if (size > 0) {
			spath = new StringStream(path);
			img = CreateImage(spath, getfiletype(path), data, size);
		}
		if (data != 0) delete[] data;
	}

	return (img);
}
