#ifndef ___FILEIMAGE_H___
#define ___FILEIMAGE_H___

#include "SmartPointer.h"

enum
{
	IMAGESYSTEM_NULL = 0,
	IMAGESYSTEM_CBM,
	IMAGESYSTEM_ATR
};

enum
{
	IMAGETYPE_NULL = 0,
	IMAGETYPE_D64_170K,
	IMAGETYPE_D64_192K,
	IMAGETYPE_D64_340K,
	IMAGETYPE_ATR_90K,
	IMAGETYPE_ATR_130K,
	IMAGETYPE_ATR_180K
};

#define IMAGEFLAG_NULL				0
#define IMAGEFLAG_NEW				1
#define IMAGEFLAG_CHANGED			2
#define IMAGEFLAG_INVALID_BAM		4
#define IMAGEFLAG_LOOPED_DIR		8
#define IMAGEFLAG_CORRUPT_DIRLINK	16

class FileImage
{
protected:
	SP<class StringStream> Path;	// path + filename of current image
	int Type;
	unsigned long Flags;

	unsigned char *Image;
	int Size;

	short Tracks;					// number of tracks
	short TotalSectors;				// total number of sectors

	void DebugPrint(const char *str);

	// test the directory entries and BAM for validity and set flags according to that
	virtual void TestDirectory(void);

public:
	FileImage(void);
	virtual ~FileImage(void);

	void SetPath(SP<class StringStream> path);
	SP<class StringStream> GetPath(void);

	int GetType(void);

	virtual void SetHeader(SP<class ByteBuffer> header);
	virtual bool HasHeader(void);
	virtual int GetImageSystem(void);

	virtual void Validate(void);
	virtual bool AddSeperator(void);
	virtual bool WriteFile(class C64File *file);
	virtual void ScratchFile(unsigned long index);
	virtual C64File *GetFile(unsigned long index);
	virtual struct CbmList *GetDirectory(void);

	virtual void Save(const char *filename);
	virtual SP<class StringStream> SaveFile(SP<class StringStream> temppath, unsigned long index);

	virtual unsigned char *GetDirEntry(unsigned long index);
	virtual void SwapDirEntries(unsigned long index1, unsigned long index2);
	virtual unsigned char *GetHeader(void);
	SP<class StringStream> GetInfoText(void);

	virtual class FileImage *Clone(void);
	bool IsEqual(class FileImage *img);

	bool Exists(void);
};

class FileImage *CreateImage(SP<class StringStream> path, int type, const unsigned char *data, int size);
class FileImage *CreateImage(const char *path);

#endif
