#include "FileP00.h"
#include "c64file.h"
#include "FileContainer.h"
#include "petscii.h"
#include "files.h"

class FileContainer *ParsePRG(SP<class StringStream> path, unsigned char type, const unsigned char *data, int size)
{
	class FileContainer *fc;
	unsigned char *fdata;
	int i;
	SP<ByteBuffer> pet;

	if ((size < 0) || (data == 0)) return (0);

	fdata = new unsigned char[size];
	for (i=0;i<size;i++) fdata[i] = data[i];

	fc = new FileContainer(path);
	if (type == 0x00) {
		// if unknown type, keep extension
		type = 0x82;
		pet = filename2petscii(getfilename(path));
	} else {
		// if known type, strip extension
		pet = filename2petscii(getnameonly(path));
	}
	fc->Add(new C64File(pet, fdata, size, type, FILEFORMAT_CBM));
	return (fc);
}
