#include "FileStream.h"
#include <stdio.h>

#define FILESTREAM_MAXSIZE (4*1024*1024)

//static unsigned char tempbuffer[1024];

void FileStream::Init(const unsigned char *data, unsigned long size)
{
	unsigned long i;

	Data = 0;
	Size = 0;
	Position = 0;

	if (data == 0) return;

	Size = size;
	Data = new unsigned char[Size];

	for (i=0;i<Size;i++) Data[i] = data[i];
}

bool FileStream::Init(const char *path)
{
	FILE *f;
	size_t frd;
	bool valid;

	if (!path) return (false);

	Data = 0;
	Size = 0;
	Position = 0;

	valid = false;
	f = fopen(path, "rb");
	if (f) {
		fseek(f, 0, SEEK_END);
		Size = ftell(f);
		if (Size > FILESTREAM_MAXSIZE) Size = FILESTREAM_MAXSIZE;
		fseek(f, 0, SEEK_SET);

		Data = new unsigned char[Size];
		frd = fread((void *)Data, 1, Size, f);
		fclose(f);

		valid = (frd == Size);
	}

	return (valid);
}

void FileStream::Exit(void)
{
	if (Data) {
		delete[] Data;
		Data = 0;
	}
}

bool FileStream::AtEnd(void)
{
	return (Position >= Size);
}

void FileStream::SetPos(unsigned long p)
{
	Position = p;
}

unsigned char FileStream::NextByte(void)
{
	if (Position >= Size) return (0);

	return (Data[Position++]);
}

unsigned short FileStream::NextWord(void)
{
	unsigned short x;

	x  = NextByte();
	x <<= 8;
	x |= NextByte();

	return (x);
}

unsigned long FileStream::NextLong(void)
{
	unsigned long x;

	x  = NextByte();
	x <<= 8;
	x |= NextByte();
	x <<= 8;
	x |= NextByte();
	x <<= 8;
	x |= NextByte();

	return (x);
}

unsigned char *FileStream::NextLine(void)
{
	unsigned char *tdata;
	unsigned long i, sz;
	unsigned char c;

	i = Position;
	sz = 0;
	while (i < Size) {
		c = Data[i];
		if ((c == 0) || (c == 0x0D)) break;
		i++;
		sz++;
	}

	tdata = new unsigned char[sz+1];
	for (i=0;i<sz;i++) {
		tdata[i] = Data[Position++];
	}
	tdata[sz] = 0;
	if (Position < Size) Position++;

	return (tdata);
}

void FileStream::SkipLine(void)
{
	unsigned char c;

	while (Position < Size) {
		c = Data[Position++];
		if ((c == 0) || (c == 0x0D)) break;
	}
}

void FileStream::SkipDelimiters(void)
{
	while (Position < Size) {
		if (Data[Position] != 0x20) break;
		Position++;
	}
}

unsigned long FileStream::ParseInteger(void)
{
	unsigned long val;
	unsigned char c;

	SkipDelimiters();

	val = 0;
	while (Position < Size) {
		c = Data[Position];
		if ((c < '0') || (c > '9')) break;
		val *= 10;
		val += (c - '0');
		Position++;
	}

	return (val);
}

bool FileStream::HasInteger(void)
{
	unsigned char c;

	if (Position < Size) {
		c = Data[Position];
		return ((c >= '0') && (c <= '9'));
	}

	return (false);
}

unsigned long FileStream::ReadData(unsigned char *buffer, unsigned long p, unsigned long s)
{
	unsigned long i;

	if (p >= Size) return (0);
	if ((p + s) > Size) s = (Size - p);

	for (i=0;i<s;i++) buffer[i] = Data[i+p];

	return (s);
}

