#include "ImageMap.h"
#include "debug.h"

ImageMap::ImageMap(void)
{
	Tracks = 0;
	Sectors = 0;
	Map = 0;
}

ImageMap::~ImageMap(void)
{
	if (Sectors) delete[] Sectors;
	if (Map) delete[] Map;
}

ImageMap::ImageMap(int trk, int sec)
{
	int i;

	Tracks = trk;
	Sectors = new int[Tracks];
	Map = new unsigned char[Tracks*sec];

	for (i=0;i<Tracks;i++) Sectors[i] = sec;

	Clear();
}

void ImageMap::Clear(void)
{
	int k, i, sec;

	sec = Sectors[0];

	for (k=0;k<Tracks;k++) {
//		sDPrintF("%i\n", Sectors[k]);

		for (i=0;i<Sectors[k];i++) {
			Map[k*sec + i] = 0;
		}
	}
}

void ImageMap::Set(int trk, int sec)
{
	trk--;

	if (trk < 0) return;
	if (trk >= Tracks) return;
	if (sec < 0) return;
	if (sec >= Sectors[trk]) return;

	Map[trk*Sectors[0] + sec] = 1;
}

bool ImageMap::Get(int trk, int sec)
{
	trk--;

	if (trk < 0) return true;
	if (trk >= Tracks) return true;
	if (sec < 0) return true;
	if (sec >= Sectors[trk]) return true;

	return (Map[trk*Sectors[0] + sec] != 0);
}
