#include "Win32_CheckBoxControl.h"

#include "resource.h"

extern void CreateControl(HWND parent, int label, unsigned int style, char *wclass, char *text, unsigned int flags);

CheckBoxControl::CheckBoxControl(HWND parent, HINSTANCE hInstance, char *string)
{
	CreateControl(parent, hInstance, "BUTTON",
		WS_CHILD | WS_VISIBLE | BS_CHECKBOX | BS_NOTIFY, 64, 30);

	SendMessage(Handle, WM_SETTEXT, 0, (LPARAM)(LPCTSTR) string);
//	if (defcheck) SendMessage(Handle, BM_SETCHECK, (WPARAM) BST_CHECKED, 0);
}

int CheckBoxControl::GetCheck(void)
{
	int check;

	check = 0;
	if (Handle) {
		check = SendMessage(Handle, BM_GETCHECK, 0, 0);
	}
	return (check);
}

void CheckBoxControl::SetCheck(int check)
{
	if (Handle) {
		if (check) SendMessage(Handle, BM_SETCHECK, (WPARAM) BST_CHECKED, 0);
		else SendMessage(Handle, BM_SETCHECK, (WPARAM) BST_UNCHECKED, 0);
	}
}
