#include "Win32_LogDisplay.h"
#include "resource.h"

extern void CreateControl(HWND parent, int label, unsigned int style, char *wclass, char *text, unsigned int flags);

LogDisplay::LogDisplay(HWND parent, HINSTANCE hInstance)
{
	CreateControl(parent, hInstance, "LISTBOX",
		WS_CHILD | WS_VISIBLE | WS_VSCROLL | WS_BORDER | LBS_NOINTEGRALHEIGHT, 64, 30);
}

void LogDisplay::Add(const char *string)
{
	HWND hwnd;
	int count;

	hwnd = Handle;
	if ((hwnd) && (string)) {
		SendMessage(hwnd, LB_ADDSTRING, 0, (LPARAM)string);
		count = SendMessage(hwnd, LB_GETCOUNT, 0, 0);
		if (count > 0) SendMessage(hwnd, LB_SETTOPINDEX, (WPARAM)count-1, 0);
	}
}
