#include "Win32_PushButton.h"

#include "resource.h"

extern void CreateControl(HWND parent, int label, unsigned int style, char *wclass, char *text, unsigned int flags);

PushButton::PushButton(HWND parent, HINSTANCE hInstance, char *string)
{
	CreateControl(parent, hInstance, "BUTTON",
		WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, 64, 30);

	SendMessage(Handle, WM_SETTEXT, 0, (LPARAM)(LPCTSTR) string);
}

PushButton::PushButton(HWND parent, HINSTANCE hInstance, char *string, int defpush)
{
	int flags;

	flags = 0;
	if (defpush) flags = BS_DEFPUSHBUTTON;

	CreateControl(parent, hInstance, "BUTTON",
		WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON | flags, 64, 30);

	SendMessage(Handle, WM_SETTEXT, 0, (LPARAM)(LPCTSTR) string);
}

void PushButton::SetIcon(HANDLE icon)
{
	if (Handle) {
		SendMessage(Handle, BM_SETSTYLE, (WPARAM) LOWORD(WS_CHILD | WS_VISIBLE | WS_GROUP | BS_PUSHBUTTON | BS_ICON), MAKELPARAM(FALSE, 0));
		SendMessage(Handle, BM_SETIMAGE, (WPARAM) IMAGE_ICON, (LPARAM) (HANDLE) icon);
	}
}

void PushButton::SetHighlight(int state)
{
	if (Handle) SendMessage(Handle, BM_SETSTATE, (WPARAM) state, 0);
}
