#include "windows.h"
#include "Win32_WindowConfig.h"
#include "Win32_StaticControl.h"
#include "Win32_CheckBoxControl.h"
#include "Win32_ComboBox.h"
#include "Win32_PushButton.h"
#include "Win32_EditControl.h"
#include "resource.h"
#include "stringops.h"
#include "debug.h"
#include "GlobalConfig.h"
#include "StringStream.h"

static WindowConfig *ConfigWin = 0;

static LRESULT CALLBACK HelpCallBack(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	if (ConfigWin) return ConfigWin->ProcessMessage(hwnd, msg, wParam, lParam);
	return DefWindowProc(hwnd, msg, wParam, lParam);
}

char *InterleaveStrings[]=
{
	"1",
	"2",
	"3",
	"4",
	"5",
	"6",
	"7",
	"8",
	"9",
	"10",
	"11",
	"12",
	"13",
	"14",
	"15",
	"16",
	"17",
	"18",
	"19",
	"20",
	0
};

char *StrategyStrings[]=
{
	"Closest",
	"Linear",
	"Sublinear",
	0
};

SP<StringStream> OpenExeRequester(HWND handle, SP<StringStream> filename)
{
	OPENFILENAME ofn;
	BOOL ok;
	int i;
	char *fname;
	char *str;
	SP<StringStream> fret;

	for (i=0;i<sizeof(ofn);i++) ((unsigned char *)(&ofn))[i] = 0;

	str = filename->GetString();
	fname = new char[MAX_PATH];
	i = 0;
	while ((i < (MAX_PATH-1)) && (str != 0) && (str[i] != 0)) {
		fname[i] = str[i];
		i++;
	}
	fname[i] = 0;

	ofn.lStructSize = sizeof(ofn);
	ofn.hwndOwner = handle;
	ofn.lpstrFile = fname;
	ofn.nMaxFile = MAX_PATH;
	ofn.nFilterIndex = 2;
	ofn.lpstrFilter = "All files\0*\0Executable\0*.EXE\0\0";
	ofn.Flags = OFN_FILEMUSTEXIST;

	ok = GetOpenFileName(&ofn);

	fret = 0;
	if (ok) fret = new StringStream(fname);

	delete[] fname;

	return (fret);
}

WindowConfig::WindowConfig(HINSTANCE hInstance)
{
	Instance = hInstance;
	Text = 0;
	FileTrack18 = 0;
	DirTrack18 = 0;
	InterleaveText = 0;
	Interleave = 0;
	StrategyText = 0;
	Strategy = 0;
	IPText = 0;
	EditIP = 0;
	PortText = 0;
	EditPort = 0;

	TextX64 = 0;
	EditX64 = 0;
	ButtonX64 = 0;

	ButtonOk = 0;
}

WindowConfig::~WindowConfig(void)
{
	CloseControls();
}

void WindowConfig::CloseControls(void)
{
	if (Text) delete Text;
	if (FileTrack18) delete FileTrack18;
	if (DirTrack18) delete DirTrack18;
	if (InterleaveText) delete InterleaveText;
	if (Interleave) delete Interleave;
	if (StrategyText) delete StrategyText;
	if (Strategy) delete Strategy;
	if (IPText) delete IPText;
	if (EditIP) delete EditIP;
	if (PortText) delete PortText;
	if (EditPort) delete EditPort;
	if (TextX64) delete TextX64;
	if (EditX64) delete EditX64;
	if (ButtonX64) delete ButtonX64;
	if (ButtonOk) delete ButtonOk;
	Text = 0;
	FileTrack18 = 0;
	DirTrack18 = 0;
	InterleaveText = 0;
	Interleave = 0;
	StrategyText = 0;
	Strategy = 0;
	IPText = 0;
	EditIP = 0;
	PortText = 0;
	EditPort = 0;
	TextX64 = 0;
	EditX64 = 0;
	ButtonX64 = 0;
	ButtonOk = 0;
}

void WindowConfig::Open(HWND parent)
{
	WNDCLASSEX wc;
	HWND Handle;
	long x, y;
	char clsname[]="Arc64_WindowConfig";
	char wintitle[]="Settings";

	if (ConfigWin) return;
	ConfigWin = this;

	wc.cbSize		= sizeof(WNDCLASSEX);
	wc.style		= 0;
	wc.lpfnWndProc	= HelpCallBack;
	wc.cbClsExtra	= 0;
	wc.cbWndExtra	= 0;
	wc.hInstance	= Instance;
	wc.hIcon		= LoadIcon(Instance, MAKEINTRESOURCE(IDI_ICON2));
	wc.hIconSm		= LoadIcon(Instance, MAKEINTRESOURCE(IDI_ICON1));
	wc.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = GetSysColorBrush(COLOR_3DFACE);
	wc.lpszMenuName	= NULL;
	wc.lpszClassName= clsname;

	if (!RegisterClassEx(&wc)) {
//		MessageBox(NULL, "Could not register window!", "Error!",
	//		MB_ICONEXCLAMATION | MB_OK);
		//return;
	}

	x = 300;
	y = 300;

	Handle = CreateWindowEx(0,
		clsname, wintitle,
		WS_OVERLAPPEDWINDOW & (~(WS_MINIMIZEBOX | WS_MAXIMIZEBOX)),
		CW_USEDEFAULT, CW_USEDEFAULT, x, y,
		parent, NULL, Instance, NULL);

	if (Handle == NULL) {
		ConfigWin = 0;
		MessageBox(NULL, "Could not create window!", "Error!",
			MB_ICONEXCLAMATION | MB_OK);
		return;
	}

	ShowWindow(Handle, SW_SHOW);
	UpdateWindow(Handle);
}

LRESULT WindowConfig::ProcessMessage(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	RECT clientrect;
	int sel, y;
	SP<StringStream> str;

	switch (msg)
	{
	default:
		break;

	case WM_COMMAND:
	case WM_NOTIFY:
		if ((FileTrack18) && (HIWORD(wParam) == BN_CLICKED)) {
			if (FileTrack18->IsControl((HWND)lParam)) {
				sel = !FileTrack18->GetCheck();
				FileTrack18->SetCheck(sel);
				Config->UseTrack18 = (sel != 0);
			}
		}

		if ((DirTrack18) && (HIWORD(wParam) == BN_CLICKED)) {
			if (DirTrack18->IsControl((HWND)lParam)) {
				sel = !DirTrack18->GetCheck();
				DirTrack18->SetCheck(sel);
				Config->DirTrack18Only = (sel != 0);
			}
		}

		if ((Interleave) && (HIWORD(wParam) == CBN_SELCHANGE)) {
			if (Interleave->IsControl((HWND)lParam)) {
				Config->Interleave = Interleave->GetSelection()+1;
			}
		}

		if ((Strategy) && (HIWORD(wParam) == CBN_SELCHANGE)) {
			if (Strategy->IsControl((HWND)lParam)) {
				Config->Strategy = Strategy->GetSelection();
			}
		}

		if ((ButtonX64) && (HIWORD(wParam) == BN_CLICKED)) {
			if (ButtonX64->IsControl((HWND)lParam)) {
				str = OpenExeRequester(hwnd, Config->GetX64Path());
				if (str != 0) {
					Config->SetX64Path(str);
					EditX64->SetText(str);
				}
			}
		}

		if ((ButtonOk) && (HIWORD(wParam) == BN_CLICKED)) {
			if (ButtonOk->IsControl((HWND)lParam)) {

				Config->SetIP(EditIP->GetText());
				Config->SetX64Path(EditX64->GetText());
				Config->Save();

				CloseControls();
				DestroyWindow(hwnd);
			}
		}
/*
		if ((EditPort) && (HIWORD(wParam) == EN_CHANGE)) {
			if (EditPort->IsControl((HWND)lParam)) {
				char tmpint[16];
				EditPort->GetText(tmpint, 5);
				sel = parseint(tmpint);
				if (sel > 65535) sel = 65535;
				if (sel < 0) sel = 0;
//				EditPort->SetText(tmpint, 5);
				Config->Port = sel;
				sDPrintF("EM %i\n", sel);
			}
		}
*/

		return 0;

	case WM_KEYDOWN:
		switch (wParam)
		{
		default:
			break;
		case (VK_RETURN):
		case (VK_ESCAPE):
			CloseControls();
			DestroyWindow(hwnd);
			break;
		}
		break;

	case WM_CLOSE:
		CloseControls();
		DestroyWindow(hwnd);
		return 0;

	case WM_DESTROY:
		delete ConfigWin;
		ConfigWin = 0;
		break;

	case WM_CREATE:
		Text = new StaticControl(hwnd, Instance, "D64 settings:");
		FileTrack18 = new CheckBoxControl(hwnd, Instance, "Use track 18 for files");
		DirTrack18 = new CheckBoxControl(hwnd, Instance, "Limit directory to track 18");
		InterleaveText = new StaticControl(hwnd, Instance, "Interleave:");
		Interleave = new ComboBox(hwnd, Instance, InterleaveStrings, Config->Interleave-1);
		StrategyText = new StaticControl(hwnd, Instance, "Strategy:");
		Strategy = new ComboBox(hwnd, Instance, StrategyStrings, Config->Strategy);
		IPText = new StaticControl(hwnd, Instance, "IP:");
		EditIP = new EditControl(hwnd, Instance, Config->GetIP());
		PortText = new StaticControl(hwnd, Instance, "Port:");
		EditPort = new EditControl(hwnd, Instance, new StringStream(Config->GetNetPort()));

		TextX64 = new StaticControl(hwnd, Instance, "x64:");
		EditX64 = new EditControl(hwnd, Instance, Config->GetX64Path());
		ButtonX64 = new PushButton(hwnd, Instance, "Change");

		ButtonOk = new PushButton(hwnd, Instance, "Ok");

		FileTrack18->SetCheck(Config->UseTrack18);
		DirTrack18->SetCheck(Config->DirTrack18Only);

		EditIP->SetLimit(15);
		EditPort->SetLimit(5);

//		EditIP->SetReadOnly(1);
		EditPort->SetReadOnly(1);

		return 0;

	case WM_ERASEBKGND:
		if (Text) Text->ExcludeFrom((HDC)wParam);
		if (FileTrack18) FileTrack18->ExcludeFrom((HDC)wParam);
		if (DirTrack18) DirTrack18->ExcludeFrom((HDC)wParam);
		if (InterleaveText) InterleaveText->ExcludeFrom((HDC)wParam);
//		if (Interleave) Interleave->ExcludeFrom((HDC)wParam);
		if (StrategyText) StrategyText->ExcludeFrom((HDC)wParam);
//		if (Strategy) Strategy->ExcludeFrom((HDC)wParam);

		if (IPText) IPText->ExcludeFrom((HDC)wParam);
		if (EditIP) EditIP->ExcludeFrom((HDC)wParam);
		if (PortText) PortText->ExcludeFrom((HDC)wParam);
		if (EditPort) EditPort->ExcludeFrom((HDC)wParam);

		if (TextX64) TextX64->ExcludeFrom((HDC)wParam);
		if (EditX64) EditX64->ExcludeFrom((HDC)wParam);
		if (ButtonX64) ButtonX64->ExcludeFrom((HDC)wParam);

		if (ButtonOk) ButtonOk->ExcludeFrom((HDC)wParam);
		break;

	case WM_PAINT:
		if (Text) Text->Update(hwnd);
		if (FileTrack18) FileTrack18->Update(hwnd);
		if (DirTrack18) DirTrack18->Update(hwnd);
		if (InterleaveText) InterleaveText->Update(hwnd);
		if (Interleave) Interleave->Update(hwnd);
		if (StrategyText) StrategyText->Update(hwnd);
		if (Strategy) Strategy->Update(hwnd);
		if (IPText) IPText->Update(hwnd);
		if (EditIP) EditIP->Update(hwnd);
		if (PortText) PortText->Update(hwnd);
		if (EditPort) EditPort->Update(hwnd);

		if (TextX64) TextX64->Update(hwnd);
		if (EditX64) EditX64->Update(hwnd);
		if (ButtonX64) ButtonX64->Update(hwnd);

		if (ButtonOk) ButtonOk->Update(hwnd);
		return 0;

	case WM_SIZE:
		GetClientRect(hwnd, &clientrect);

		y = 8;
		if (Text) Text->SetPos(8, y, clientrect.right-16, 20);					y += 32;
		if (FileTrack18) FileTrack18->SetPos(8, y, clientrect.right-16, 20);	y += 28;
		if (DirTrack18) DirTrack18->SetPos(8, y, clientrect.right-16, 20);		y += 32;
		if (InterleaveText) InterleaveText->SetPos(8, y, 80, 20);
		if (Interleave) Interleave->SetPos(80+8, y-3, 100, 400);				y += 28;
		if (StrategyText) StrategyText->SetPos(8, y, 80, 20);
		if (Strategy) Strategy->SetPos(80+8, y-3, 100, 400);					y += 36;
		if (IPText) IPText->SetPos(8, y, 32, 20);
		if (EditIP) EditIP->SetPos(8+32+8, y-6, 200, 28);
		if (PortText) PortText->SetPos(8+32+8+200+16, y, 32, 20);
		if (EditPort) EditPort->SetPos(8+32+8+200+16+32+8, y-6, 54, 28);		y += 36;

		if (TextX64) TextX64->SetPos(8, y, 32, 20);
		if (EditX64) EditX64->SetPos(8+32+8, y-6, 200, 28);
		if (ButtonX64) ButtonX64->SetPos(8+32+8+200+8, y-1, 70, 20);

		if (ButtonOk) ButtonOk->SetPos(8, clientrect.bottom-38, 70, 30);

		return 0;

	case WM_GETMINMAXINFO:
		MINMAXINFO FAR *mmi;
		mmi = (MINMAXINFO FAR *) lParam;
		mmi->ptMinTrackSize.x = 400+GetSystemMetrics(SM_CXFRAME)*2;
		mmi->ptMinTrackSize.y = GetSystemMetrics(SM_CYFRAME)*2+GetSystemMetrics(SM_CYCAPTION)+212+28+36;
		mmi->ptMaxTrackSize.x = mmi->ptMinTrackSize.x;
		mmi->ptMaxTrackSize.y = mmi->ptMinTrackSize.y;
		return 0;
	}
	return DefWindowProc(hwnd, msg, wParam, lParam);
}

