#include "Win32_WindowHelp.h"
#include "Win32_StaticControl.h"
#include "Win32_PushButton.h"
#include "resource.h"
#include "stringops.h"
#include "debug.h"

static WindowHelp *HelpWin = 0;

static LRESULT CALLBACK HelpCallBack(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	if (HelpWin) return HelpWin->ProcessMessage(hwnd, msg, wParam, lParam);
	return DefWindowProc(hwnd, msg, wParam, lParam);
}

WindowHelp::WindowHelp(HINSTANCE hInstance, const char *hstr, const char *str)
{
	HeadString = hstr;
	TextString = str;
	Instance = hInstance;
	Text = 0;
	ButtonOk = 0;
}

WindowHelp::~WindowHelp(void)
{
	CloseControls();
}

void WindowHelp::CloseControls(void)
{
	if (Text) delete Text;
	if (ButtonOk) delete ButtonOk;
	Text = 0;
	ButtonOk = 0;
}

void WindowHelp::Open(HWND parent)
{
	WNDCLASSEX wc;
	HWND Handle;
	long x, y;
	char clsname[]="Arc64_WindowHelp";

	if (HelpWin) return;
	HelpWin = this;

	wc.cbSize		= sizeof(WNDCLASSEX);
	wc.style		= 0;
	wc.lpfnWndProc	= HelpCallBack;
	wc.cbClsExtra	= 0;
	wc.cbWndExtra	= 0;
	wc.hInstance	= Instance;
	wc.hIcon		= LoadIcon(Instance, MAKEINTRESOURCE(IDI_ICON2));
	wc.hIconSm		= LoadIcon(Instance, MAKEINTRESOURCE(IDI_ICON1));
	wc.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = GetSysColorBrush(COLOR_3DFACE);
	wc.lpszMenuName	= NULL;
	wc.lpszClassName= clsname;

	if (!RegisterClassEx(&wc)) {
//		MessageBox(NULL, "Could not register window!", "Error!",
	//		MB_ICONEXCLAMATION | MB_OK);
		//return;
	}

	x = 300;
	y = 300;

	Handle = CreateWindowEx(0,
		clsname, HeadString,
		WS_OVERLAPPEDWINDOW & (~(WS_MINIMIZEBOX | WS_MAXIMIZEBOX)),
		CW_USEDEFAULT, CW_USEDEFAULT, x, y,
		parent, NULL, Instance, NULL);

	if (Handle == NULL) {
		HelpWin = 0;
		MessageBox(NULL, "Could not create window!", "Error!",
			MB_ICONEXCLAMATION | MB_OK);
		return;
	}

	ShowWindow(Handle, SW_SHOW);
	UpdateWindow(Handle);
}

LRESULT WindowHelp::ProcessMessage(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	RECT clientrect;

	switch (msg)
	{
	default:
		break;

	case WM_COMMAND:
	case WM_NOTIFY:
		if ((ButtonOk) && (HIWORD(wParam) == BN_CLICKED)) {
			if (ButtonOk->IsControl((HWND)lParam)) {
				CloseControls();
				DestroyWindow(hwnd);
			}
		}
		return 0;

	case WM_KEYDOWN:
		switch (wParam)
		{
		default:
			break;
		case (VK_RETURN):
		case (VK_ESCAPE):
			CloseControls();
			DestroyWindow(hwnd);
			break;
		}
		break;

	case WM_CLOSE:
		CloseControls();
		DestroyWindow(hwnd);
		return 0;

	case WM_DESTROY:
		delete HelpWin;
		HelpWin = 0;
		break;

	case WM_CREATE:
		Text = new StaticControl(hwnd, Instance, TextString);
		ButtonOk = new PushButton(hwnd, Instance, "Ok");
		return 0;

	case WM_ERASEBKGND:
		if (Text) Text->ExcludeFrom((HDC)wParam);
		if (ButtonOk) ButtonOk->ExcludeFrom((HDC)wParam);
		break;

	case WM_PAINT:
		if (Text) Text->Update(hwnd);
		if (ButtonOk) ButtonOk->Update(hwnd);
		return 0;

	case WM_SIZE:
		GetClientRect(hwnd, &clientrect);

		if (Text) Text->SetPos(8, 8, clientrect.right-16, clientrect.bottom-38-16);
		if (ButtonOk) ButtonOk->SetPos(8, clientrect.bottom-38, 70, 30);
		return 0;

	case WM_GETMINMAXINFO:
		MINMAXINFO FAR *mmi;
		mmi = (MINMAXINFO FAR *) lParam;
		mmi->ptMinTrackSize.x = 310+GetSystemMetrics(SM_CXFRAME)*2;
		mmi->ptMinTrackSize.y = GetSystemMetrics(SM_CYFRAME)*2+GetSystemMetrics(SM_CYCAPTION)+200;
		mmi->ptMaxTrackSize.x = mmi->ptMinTrackSize.x;
		mmi->ptMaxTrackSize.y = mmi->ptMinTrackSize.y;
		return 0;
	}
	return DefWindowProc(hwnd, msg, wParam, lParam);
}

