#include "Win32_WindowNewImage.h"
#include "Win32_StaticControl.h"
#include "Win32_ComboBox.h"
#include "Win32_PushButton.h"
#include "resource.h"
#include "stringops.h"
#include "debug.h"
#include "GlobalConfig.h"
#include "FileImage.h"
#include "window.h"

static WindowNewImage *NewImageWin = 0;

static LRESULT CALLBACK HelpCallBack(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	if (NewImageWin) return NewImageWin->ProcessMessage(hwnd, msg, wParam, lParam);
	return DefWindowProc(hwnd, msg, wParam, lParam);
}

char *NewImageStrings[]=
{
	"D64 (170k)",
	"D71 (340k)",
	"ATR (90k)",
	"ATR (130k)",
	0
};

int NewImageTypes[]=
{
	IMAGETYPE_D64_170K,
	IMAGETYPE_D64_340K,
	IMAGETYPE_ATR_90K,
	IMAGETYPE_ATR_130K,
	0
};

WindowNewImage::WindowNewImage(HINSTANCE hInstance, CbmWindow *mainwin)
{
	Instance = hInstance;
	MainWin = mainwin;
	Text = 0;
	ImageSelect = 0;
	ButtonOk = 0;
	ButtonCancel = 0;
}

WindowNewImage::~WindowNewImage(void)
{
	CloseControls();
}

void WindowNewImage::CloseControls(void)
{
	if (Text) delete Text;
	if (ImageSelect) delete ImageSelect;
	if (ButtonOk) delete ButtonOk;
	if (ButtonCancel) delete ButtonCancel;
	Text = 0;
	ImageSelect = 0;
	ButtonOk = 0;
	ButtonCancel = 0;
}

void WindowNewImage::Open(HWND parent)
{
	WNDCLASSEX wc;
	HWND Handle;
	long x, y;
	char clsname[]="Arc64_WindowNewImage";
	char wintitle[]="New image";

	if (NewImageWin) return;
	NewImageWin = this;

	wc.cbSize		= sizeof(WNDCLASSEX);
	wc.style		= 0;
	wc.lpfnWndProc	= HelpCallBack;
	wc.cbClsExtra	= 0;
	wc.cbWndExtra	= 0;
	wc.hInstance	= Instance;
	wc.hIcon		= LoadIcon(Instance, MAKEINTRESOURCE(IDI_ICON2));
	wc.hIconSm		= LoadIcon(Instance, MAKEINTRESOURCE(IDI_ICON1));
	wc.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = GetSysColorBrush(COLOR_3DFACE);
	wc.lpszMenuName	= NULL;
	wc.lpszClassName= clsname;

	if (!RegisterClassEx(&wc)) {
//		MessageBox(NULL, "Could not register window!", "Error!",
	//		MB_ICONEXCLAMATION | MB_OK);
		//return;
	}

	x = 300;
	y = 300;

	Handle = CreateWindowEx(0,
		clsname, wintitle,
		WS_OVERLAPPEDWINDOW & (~(WS_MINIMIZEBOX | WS_MAXIMIZEBOX)),
		CW_USEDEFAULT, CW_USEDEFAULT, x, y,
		parent, NULL, Instance, NULL);

	if (Handle == NULL) {
		NewImageWin = 0;
		MessageBox(NULL, "Could not create window!", "Error!",
			MB_ICONEXCLAMATION | MB_OK);
		return;
	}

	ShowWindow(Handle, SW_SHOW);
	UpdateWindow(Handle);
}

LRESULT WindowNewImage::ProcessMessage(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	RECT clientrect;
	int y, close;

	switch (msg)
	{
	default:
		break;

	case WM_COMMAND:
	case WM_NOTIFY:
		close = 0;

		if ((ImageSelect) && (HIWORD(wParam) == CBN_SELCHANGE)) {
			if (ImageSelect->IsControl((HWND)lParam)) {
//				Config->Interleave = Interleave->GetSelection()+1;
			}
		}

		if ((ButtonOk) && (HIWORD(wParam) == BN_CLICKED)) {
			if (ButtonOk->IsControl((HWND)lParam)) {
				close = 1;
				MainWin->NewImage(NewImageTypes[ImageSelect->GetSelection()]);
			}
		}

		if ((ButtonCancel) && (HIWORD(wParam) == BN_CLICKED)) {
			if (ButtonCancel->IsControl((HWND)lParam)) {
				close = 1;
			}
		}

		if (close) {
			CloseControls();
			DestroyWindow(hwnd);
		}
		return 0;

	case WM_KEYDOWN:
		switch (wParam)
		{
		default:
			break;
		case (VK_RETURN):
		case (VK_ESCAPE):
			CloseControls();
			DestroyWindow(hwnd);
			break;
		}
		break;

	case WM_CLOSE:
		CloseControls();
		DestroyWindow(hwnd);
		return 0;

	case WM_DESTROY:
		delete NewImageWin;
		NewImageWin = 0;
		break;

	case WM_CREATE:
		Text = new StaticControl(hwnd, Instance, "Create empty image:");
		ImageSelect = new ComboBox(hwnd, Instance, NewImageStrings, 0);
		ButtonOk = new PushButton(hwnd, Instance, "Ok");
		ButtonCancel = new PushButton(hwnd, Instance, "Cancel");

		return 0;

	case WM_ERASEBKGND:
		if (Text) Text->ExcludeFrom((HDC)wParam);
//		if (ImageSelect) ImageSelect->ExcludeFrom((HDC)wParam);
		if (ButtonOk) ButtonOk->ExcludeFrom((HDC)wParam);
		if (ButtonCancel) ButtonCancel->ExcludeFrom((HDC)wParam);
		break;

	case WM_PAINT:
		if (Text) Text->Update(hwnd);
		if (ImageSelect) ImageSelect->Update(hwnd);
		if (ButtonOk) ButtonOk->Update(hwnd);
		if (ButtonCancel) ButtonCancel->Update(hwnd);
		return 0;

	case WM_SIZE:
		GetClientRect(hwnd, &clientrect);

		y = 8;
		if (Text) Text->SetPos(8, y, clientrect.right-16, 20);					y += 32;
		if (ImageSelect) ImageSelect->SetPos(8, y-3, 70+8+70, 400);					y += 28;
		if (ButtonOk) ButtonOk->SetPos(8, clientrect.bottom-38, 70, 30);
		if (ButtonCancel) ButtonCancel->SetPos(8+70+8, clientrect.bottom-38, 70, 30);
		return 0;

	case WM_GETMINMAXINFO:
		MINMAXINFO FAR *mmi;
		mmi = (MINMAXINFO FAR *) lParam;
		mmi->ptMinTrackSize.x = GetSystemMetrics(SM_CXFRAME)*2+8+70+8+70+8;
		mmi->ptMinTrackSize.y = GetSystemMetrics(SM_CYFRAME)*2+GetSystemMetrics(SM_CYCAPTION)+116;
		mmi->ptMaxTrackSize.x = mmi->ptMinTrackSize.x;
		mmi->ptMaxTrackSize.y = mmi->ptMinTrackSize.y;
		return 0;
	}
	return DefWindowProc(hwnd, msg, wParam, lParam);
}

