#ifndef __WINDOWRENAME_H__
#define __WINDOWRENAME_H__

#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
#endif
#include <windows.h>

#include "SmartPointer.h"
#include "StringStream.h"

class WindowRename
{
private:
	HINSTANCE Instance;

	class CbmWindow *MainWin;
	class StaticControl *Text;

	class EditControl *FileNameEdit;
	class EditControl *IdEdit;
	class ComboBox *FileType;
	class EditControl *BlockCountEdit;

	class CheckBoxControl *SelProtection;
	class CheckBoxControl *SelClosed;

	class CheckBoxControl *SelLocked;
	class CheckBoxControl *SelInUse;
	class CheckBoxControl *SelDOS2;
	class CheckBoxControl *SelOpened;
	class CheckBoxControl *SelDeleted;

	class PushButton *ButtonOk;
	class PushButton *ButtonCancel;

	unsigned long Index;
	SP<class FileImage> Image;
	struct DirEntryD64 *EntryD64;
	struct DirEntryATR *EntryATR;
	struct DirEntryHeader *EntryHeader;
	struct DirEntryD64 *TempEntryD64;
	struct DirEntryATR *TempEntryATR;
	struct DirEntryHeader *TempEntryHeader;

	SP<StringStream> String;
	SP<StringStream> Id;
	unsigned char Type;

	unsigned char Mode;

	void CloseControls(void);
	void UpdateImage(void);

public:

	WindowRename(HINSTANCE hInstance, CbmWindow *mainwin, unsigned long index, SP<class FileImage> img);
	~WindowRename(void);

	LRESULT ProcessMessage(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

	void Open(HWND parent);
};

#endif
