#ifndef ___ATR_H___
#define ___ATR_H___

#include "FileImage.h"

extern void initatr(void);

class FileATR : public FileImage
{
private:
	short SectorsPerTrack;	/* 18 or 26 */
	short SectorSize;		/* 128 or 256 */

	unsigned char *map;	/* for traversing files */

	void ClearBAM();
	unsigned char ReadBAMByte(short sector);
	void WriteBAMByte(short sector, unsigned char bambyte);
	bool IsFreeBlock(short sector);
	void AllocBlock(short sector);
	void FreeBlock(short sector);
	void ValidateLinks(short sector, short count);
	void ValidateBlockCount(void);

	bool IsValidBlock(short sector);
	unsigned char *GetBlock(short sector);
	short GetBlockLink(short sector);

	void InitMap();
	void ClearMap();
	bool AlreadyVisited(unsigned short sector);
	void SetVisitedFlag(unsigned short sector);
	void TestDirectory(void);

	long GetFileLength(unsigned short sector);
	unsigned char *GetFileBuffer(unsigned short sector);

	short AllocNextBlock(void);
	short WriteData(unsigned char *data, unsigned long size, unsigned short filenum,
					unsigned char *direntry);
	unsigned char *GetEmptyDirEntry();
	bool WriteFile(SP<ByteBuffer> name, unsigned char type, unsigned char *data, unsigned long size);
	bool AddSeperator(void);

	void CreateATRHeader(unsigned char *header);

protected:
	void Init(int type);

public:
	FileATR(void);
	FileATR(int type);
	~FileATR(void);

	void Init(SP<StringStream> path, const unsigned char *data, int size);
	class FileImage *Clone(void);

//	void SetHeader(SP<ByteBuffer> header);
	bool HasHeader(void);
	int GetImageSystem(void);

	void Validate();
//	bool AddSeperator(void);
	bool WriteFile(class C64File *file);
	void ScratchFile(unsigned long index);
	C64File *GetFile(unsigned long index);
	struct CbmList *GetDirectory();

	void Save(const char *filename);
	SP<class StringStream> SaveFile(SP<class StringStream> temppath, unsigned long index);

	unsigned char *GetDirEntry(unsigned long index);
	void SwapDirEntries(unsigned long index1, unsigned long index2);
	unsigned char *GetHeader(void);
};

FileATR *CreateATR(SP<StringStream> path, int type, const unsigned char *data, int size);

#endif
