#include "c64file.h"
#include "files.h"
#include "petscii.h"
#include <stdio.h>

SP<C64File> LoadFile(SP<StringStream> path)
{
	return 0;
}

C64File::C64File()
{
	Name = 0;
	Data = 0;
	Size = 0;
	Type = 0;
	Format = 0;
}

C64File::~C64File()
{
	if (Data) delete[] Data;
	Name = 0;
}

C64File::C64File(SP<ByteBuffer> nm, unsigned char *dt, unsigned long sz, unsigned char tp, unsigned char frm)
{
	Name = nm;
	Data = dt;
	Size = sz;
	Type = tp;
	Format = frm;
}

SP<ByteBuffer> C64File::GetName()
{
	return Name;
}

unsigned char *C64File::GetData()
{
	return Data;
}

unsigned long C64File::GetSize()
{
	return Size;
}

unsigned char C64File::GetType()
{
	return Type;
}

static bool HasExtension(const char *fname)
{
	int i;

	i = 0;
	while (fname[i] != 0) {
		if (fname[i] == '.') return (true);
		i++;
	}

	return (false);
}

SP<StringStream> C64File::Save(SP<StringStream> path)
{
	FILE *f;
	SP<StringStream> fp;
	char *ext;
	unsigned char *aname;
	char fname[13];
	char fext[5];
	int i, k;

	if (!Data) return 0;

	switch (Format)
	{
	case FILEFORMAT_CBM:
		fp = petscii2filename(Name);
		if (!HasExtension(fp->GetString()))
		{
			switch (Type & 0x0F)
			{
			default:
				ext = ".prg";
				break;
			case 0:
				ext = ".del";
				break;
			case 1:
				ext = ".seq";
				break;
			case 3:
				ext = ".usr";
				break;
			case 4:
				ext = ".rel";
				break;
			}
			fp = fp->Append(ext);
		}
		break;

	case FILEFORMAT_ATARI:
		aname = Name->GetBuffer();
		for (i=7;i>=0;i--)
		{
			if (aname[i] != ' ') break;
		}
		i++;
		for (k=0;k<i;k++) fname[k] = aname[k];
		fname[k++] = '.';
		for (i=0;i<3;i++) fname[i+k] = aname[i+8];
		fname[12] = 0;

		i=2;
		while ((i>=0) && (fname[i+k] == ' ')) {
			fname[i+k] = 0;
			i--;
		}
		if (i==0) fname[k-1] = 0;

		fp = new StringStream(fname);

//		fname[k] = 0;
//		fext[0] = '.';
//		for (k=0;k<3;k++) fext[k+1] = aname[k+8];
//		fext[4] = 0;
//		fp = newextension(new StringStream(fname), fext);
		break;
	}

	fp = getfilepath(path, fp->GetString());
	remove(fp->GetString());
	f = fopen(fp->GetString(), "wb");
	if (f)
	{
		fwrite((void *)Data, 1, Size, f);
		fclose(f);
	}

	return fp;
}
