#ifndef __CBMLIST_H__
#define __CBMLIST_H__

#define CHARSET_COMMODORE 1
#define CHARSET_ATARI 2

struct CbmList
{
private:
	unsigned char *screen;
	unsigned long linesize;
	unsigned long screenlines;

public:
	void Init(int charset);
	void Exit();
	void Add(unsigned char *line);
	struct CbmBitmap *GetBitmap();
	char *GetASCII();
};

struct CbmBitmap
{
private:
	unsigned char *bitmap;
	unsigned long linesize;
	unsigned long screenlines;

public:
	void Init(unsigned long linesize, unsigned long screenlines);
	void Exit();
	void Draw(unsigned char chr, unsigned long x, unsigned long y);
	unsigned char GetPixel(unsigned long x, unsigned long y);
	unsigned long GetWidth();
	unsigned long GetHeight();

	unsigned char GetPixelFast(unsigned long x, unsigned long y)
	{
		return (bitmap[(y*linesize)+(x>>3)] & (1 << ((x & 7) ^ 7)));
	}
};

#endif
