#include "files.h"
#include "stringops.h"
#include "StringStream.h"
#include "FileZipCode.h"
#include <stdio.h>
#include <stdlib.h>

/***************************************************************************************************/

struct Token
{
	char *string;
	unsigned int token;
};

static Token tokens[21]=
{
	{ ".C64"    , FILETYPE_PRG    },
	{ ".PRG"	, FILETYPE_PRG    },
	{ ".SEQ"	, FILETYPE_SEQ    },
	{ ".USR"	, FILETYPE_USR    },
	{ ".P00"    , FILETYPE_P00    },
	{ ".S00"    , FILETYPE_S00    },
	{ ".U00"    , FILETYPE_U00    },
	{ ".T64"    , FILETYPE_T64    },
	{ ".LNX"    , FILETYPE_LNX    },
	{ ".ARK"    , FILETYPE_ARK    },
	{ ".D64"    , FILETYPE_D64    },
	{ ".D41"    , FILETYPE_D64    },
	{ ".D71"    , FILETYPE_D64    },
	{ ".D81"    , FILETYPE_D81    },
	{ ".ATR"	, FILETYPE_ATR    },
	{ ".XFD"	, FILETYPE_XFD    },
	{ ".DCM"	, FILETYPE_DCM    },
	{ ".COM"	, FILETYPE_COM    },
	{ ".EXE"	, FILETYPE_EXE    },
	{ ".XEX"	, FILETYPE_EXE    },
	{ 0         , FILETYPE_UNKNOWN},
};

static bool tokencmp(const char *token, const char *data)
{
	unsigned int i;
	char c1,c2;

	i = 0;
	if (!data[i]) return 0;
	while (data[i])
	{
		c1 = data[i];
		c2 = token[i];
		if ((c1 >= 'a') && ( c1 <= 'z')) c1 += ('A' - 'a');
		if ((c2 >= 'a') && ( c2 <= 'z')) c2 += ('A' - 'a');
		if (c1 != c2) return 0;
		i++;
	}
	return 1;
}

static int gettoken(const char *data)
{
	unsigned int i;

	i = 0;
	while (tokens[i].string)
	{
		if (tokencmp(tokens[i].string, data)) return tokens[i].token;
		i ++;
	}
	return FILETYPE_UNKNOWN;
}

/***************************************************************************************************/

static char namebuffer[_MAX_PATH];

int FindFilenameOffset(const char *filename)
{
	int i;
	char c;

	if (filename == 0) return (0);

	i = 0;
	while (filename[i] != 0) i++;

	while (i > 0) {
		c = filename[i-1];
		if ((c == '/') || (c == '\\') || (c == ':')) break;
		i--;
	}

	return (i);
}

SP<StringStream> getfilename(SP<StringStream> path)
{
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];
	char name[_MAX_PATH];

	if (path == 0) return 0;
	if (path->GetString() == 0) return (new StringStream(""));

	_splitpath( path->GetString(), 0, 0, fname, ext );
	_makepath( name, 0, 0, fname, ext );

	return (new StringStream(name));
}

SP<StringStream> newextension(SP<StringStream> path, const char *newext)
{
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];
	char name[_MAX_PATH];

	_splitpath( path->GetString(), drive, dir, fname, ext );
	_makepath( name, drive, dir, fname, newext );

	return (new StringStream(name));
}

SP<StringStream> getfilepath(SP<StringStream> path, const char *name)
{
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];
	char nameb[_MAX_PATH];

	_splitpath( path->GetString(), drive, dir, 0, 0 );
	_splitpath( name, 0, 0, fname, ext );
	_makepath( nameb, drive, dir, fname, ext );

	return (new StringStream(nameb));
}

SP<StringStream> adddir(SP<StringStream> path, const char *adir)
{
	SP<StringStream> p = path;

	p = p->Append(adir);
	p = p->Append("\\");

	return (p);
}

SP<StringStream> getnameonly(SP<StringStream> path)
{
	char name[_MAX_PATH];

	if (path == 0) return 0;
	if (path->GetString() == 0) return (new StringStream(""));

	_splitpath( path->GetString(), 0, 0, name, 0 );

	return (new StringStream(name));
}

SP<StringStream> getextension(SP<StringStream> path)
{
	char name[_MAX_PATH];

	if (path == 0) return 0;
	if (path->GetString() == 0) return (new StringStream(""));

	_splitpath( path->GetString(), 0, 0, 0, name);

	return (new StringStream(name));
}
/*
bool hasextension(SP<StringStream> path)
{
	char ext[_MAX_EXT];

	if (path == 0) return 0;
	if (path->GetString() == 0) return 0;

	_splitpath( path->GetString(), 0, 0, 0, ext );

	return (ext[0] != 0);
}
*/
/***************************************************************************************************/

int getfiletype(const char *name)
{
	int len, token, tt;
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];

	token = FILETYPE_UNKNOWN;

	if (name == 0) return token;

	_splitpath( name, 0, 0, fname, ext );

	if (TestZipCodeFileName(name)) token = FILETYPE_ZIP;

	len = stringlen(ext);
	if (len < 4) return token;
	tt = gettoken(ext);
	if (tt != FILETYPE_UNKNOWN) token = tt;
	return token;
}

/***************************************************************************************************/

void AddExtension(char *filename, char *extension)
{
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];

	_splitpath( filename, drive, dir, fname, ext );
	if (!ext[0]) _makepath( filename, drive, dir, fname, extension );
	else _makepath( filename, drive, dir, fname, ext );
}

SP<StringStream> nextfilename(SP<StringStream> path)
{
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];
	char name[_MAX_PATH];
	int i, first;
	char c;

	if (path == 0) return 0;
	if (path->GetString() == 0) return (new StringStream(""));

	_splitpath( path->GetString(), drive, dir, fname, ext );

	i = 0;
	while (fname[i] != 0) i++;

	first = 1;
	while (i > 0) {
		i--;

		c = fname[i];
		if ((c < '0') || (c > '9')) {
			if (!first) break;
			if (c == 'a') {
				fname[i] = 'b';
				break;
			}
			if (c == 'b') {
				fname[i] = 'a';
			}

			first = 0;
		} else {

			c++;
			if (c <= '9') {
				fname[i] = c;
				break;
			}
			fname[i] = '0';
		}
	}

	_makepath( name, drive, dir, fname, ext );

	return (new StringStream(name));
}

SP<StringStream> prevfilename(SP<StringStream> path)
{
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];
	char name[_MAX_PATH];
	int i, first;
	char c;

	if (path == 0) return 0;
	if (path->GetString() == 0) return (new StringStream(""));

	_splitpath( path->GetString(), drive, dir, fname, ext );

	i = 0;
	while (fname[i] != 0) i++;

	first = 1;
	while (i > 0) {
		i--;

		c = fname[i];
		if ((c < '0') || (c > '9')) {
			if (!first) break;
			if (c == 'b') {
				fname[i] = 'a';
				break;
			}
			if (c == 'a') {
				fname[i] = 'b';
			}

			first = 0;
		} else {

			c--;
			if (c >= '0') {
				fname[i] = c;
				break;
			}
			fname[i] = '9';
		}
	}

	_makepath( name, drive, dir, fname, ext );

	return (new StringStream(name));
}

bool FileExists(SP<StringStream> path)
{
	FILE *f;

	if (path != 0) {
		f = fopen(path->GetString(), "rb");
		if (f) {
			fclose(f);
			return (true);
		}
	}

	return (false);
}
