#ifndef ___FILES_H___
#define ___FILES_H___

#include "SmartPointer.h"

enum
{
	FILETYPE_UNKNOWN = 0,
	FILETYPE_PRG,
	FILETYPE_SEQ,
	FILETYPE_USR,
	FILETYPE_P00,
	FILETYPE_S00,
	FILETYPE_U00,
	FILETYPE_T64,
	FILETYPE_LNX,
	FILETYPE_ARK,
	FILETYPE_D64,
	FILETYPE_D81,
	FILETYPE_ZIP,
	FILETYPE_ATR,
	FILETYPE_XFD,
	FILETYPE_DCM,
	FILETYPE_COM,
	FILETYPE_EXE
};

/* returns the offset to the filename within a path */
extern int FindFilenameOffset(const char *path);

/* returns filename+extension of a filepath */
extern SP<class StringStream> getfilename(SP<class StringStream> path);

/* replaces the old extension by a new one */
extern SP<class StringStream> newextension(SP<class StringStream> path, const char *newext);

/* replaces the path of a file by another path */
extern SP<class StringStream> getfilepath(SP<class StringStream> path, const char *name);

/* add a directory to a path */
extern SP<class StringStream> adddir(SP<class StringStream> path, const char *dir);

/* return name without path and without extension */
extern SP<class StringStream> getnameonly(SP<class StringStream> path);

extern SP<class StringStream> getextension(SP<class StringStream> path);

//extern bool hasextension(SP<class StringStream> name);

extern int getfiletype(const char *name);

void AddExtension(char *filename, char *extension);

/* returns path+filename where number/side is increased */
extern SP<class StringStream> nextfilename(SP<class StringStream> path);

/* returns path+filename where number/side is decreased */
extern SP<class StringStream> prevfilename(SP<class StringStream> path);

extern bool FileExists(SP<class StringStream> path);


#endif
