#include "net64.h"
#include "nethost.h"
#include <stdio.h>

static uBYTE packet[256];



#define CNETTYPE_ACK	1
#define CNETTYPE_DATA	4
#define CNETTYPE_FILL	5
#define CNETTYPE_JUMP	6
#define CNETTYPE_RUN	7
#define CNETTYPE_READ	8

#define CNET_MAXSIZE	150

#define CNET_MAGIC		0xCA1F

/*

codenet header:

0 = 0xCA
1 = 0x1F
2 = sequence number
3 = service number

// optional for DATA, FILL, JUMP:

4 = address high
5 = address low

// optional for DATA, FILL: (size is currently defined from 0 to CNET_MAXSIZE bytes)

6 = size high (usually 0 because size is limited to CNET_MAXSIZE)
7 = size low

// optional for FILL:

8 = fill-byte

// optional for DATA:

8... = data bytes (maximum CNET_MAXSIZE bytes)

*/

void Net64::Init(NetHost *hst, uLONG tout, uLONG retry)
{
	Host = hst;
	Timeout = tout;
	Retries = retry;
	Sequence = 0x41;
}

void Net64::Exit(void)
{
}

char Net64::Send(uBYTE service, uWORD size)
{
	int repeat, error;
	uBYTE reply[8];

	Sequence++;

	packet[0] = (CNET_MAGIC >> 8);
	packet[1] = (CNET_MAGIC & 0xFF);
	packet[2] = Sequence;
	packet[3] = service;

	repeat = Retries;
	while (repeat > 0) {

		if (Host->Send(packet, (size+5) & 0xFFFE)) {

			error = Host->Recv(reply, 8, Timeout);

#ifdef _DEBUG
			if (error == NETHOST_TIMEOUT) printf("NETHOST_TIMEOUT\n");
			if (error == NETHOST_ERROR) printf("NETHOST_ERROR\n");
#endif
			if (error == NETHOST_ERROR) break;

			if (error == NETHOST_OK) {

				// Paket empfangen, berprfen...
				error = 0;
				if (reply[0] != (CNET_MAGIC >> 8)) error = 1;
				if (reply[1] != (CNET_MAGIC & 0xFF)) error = 1;
				if (reply[2] != Sequence) error = 1;
				if (reply[3] >= 2) error = 1;

				if (!error) return reply[3];
			}
		}
		repeat--;
	}
	return NET64_ERROR;
}

int Net64::SendData(uWORD address, uWORD size, const uBYTE *buffer)
{
	uLONG i;

#ifdef _DEBUG
	printf("Net64::SendData(0x%04X, 0x%04X, 0x%08X);\n", address, size, buffer);
#endif

	if (size > CNET_MAXSIZE) return -1;
	packet[4] = (uBYTE)(address >> 8);
	packet[5] = (uBYTE)(address & 0xFF);
	packet[6] = (uBYTE)(size >> 8);
	packet[7] = (uBYTE)(size & 0xFF);
	for (i=0;i<size;i++) packet[i+8] = buffer[i];

	return (Send(CNETTYPE_DATA, (size+4)));
}

int Net64::SendFill(uWORD address, uWORD size, uBYTE fill)
{
#ifdef _DEBUG
	printf("Net64::SendFill(0x%04X, 0x%04X, 0x%02X);\n", address, size, fill);
#endif

	packet[4] = (uBYTE)(address >> 8);
	packet[5] = (uBYTE)(address & 0xFF);
	packet[6] = (uBYTE)(size >> 8);
	packet[7] = (uBYTE)(size & 0xFF);
	packet[8] = fill;

	return (Send(CNETTYPE_FILL, 5));
}

int Net64::ExecJump(uWORD address)
{
#ifdef _DEBUG
	printf("Net64::ExecJump(0x%04X);\n", address);
#endif

	packet[4] = (uBYTE)(address >> 8);
	packet[5] = (uBYTE)(address & 0xFF);

	return (Send(CNETTYPE_JUMP, 2));
}

int Net64::ExecRun(void)
{
#ifdef _DEBUG
	printf("Net64::ExecRun();\n");
#endif

	return (Send(CNETTYPE_RUN, 0));
}

