#include "netarc.h"
#include "net64.h"
#include "nethost.h"
#include "d64.h"
#include "c64file.h"
#include "debug.h"
#include "stringops.h"
#include "Win32_WindowCodenet.h"

WSADATA WSAData;

void NetArc::Init(char *adr, unsigned short port)
{
	socket = 0;
	host = 0;
	n64 = 0;

	if (WSAStartup(MAKEWORD(2, 0), &WSAData) == 0) {
		socket = new NetSocket;
		host = new NetHost;
		n64 = new Net64;

		socket->Init();
		host->Init(socket, adr, port);
		n64->Init(host, 250, 4);
	}
}

void NetArc::Exit(void)
{
	if (n64) {
		n64->Exit();
		delete[] n64;
		n64 = 0;
	}
	if (host) {
		host->Exit();
		delete[] host;
		host = 0;
	}
	if (socket) {
		socket->Exit();
		delete[] socket;
		socket = 0;
	}

	WSACleanup();
}

int NetArc::SendData(unsigned char *data, unsigned long size)
{
	unsigned short adr;
	unsigned long pos;
	unsigned long bsize;
	int retval;

	adr = ((unsigned short)data[1] << 8) | (unsigned short)data[0];
	pos = 2;

//	sDPrintF("SendData %i\n", size);

	retval = 0;
	while ((size > pos) && (retval >= 0)) {
		bsize = size-pos;
		if (bsize > 128) bsize = 128;

		retval = n64->SendData(adr, (unsigned short)bsize, &data[pos]);
		pos += bsize;
		adr += (unsigned short)bsize;
	}
	return retval;
}

void NetArc::RunFile(HWND hwnd, WindowCodenet *wcn, C64File *cf)
{
	unsigned char *data;
	unsigned long i,size;
	unsigned char txt1[] = "  RECEIVING FILE                          ";
	unsigned char txt2[] = "  EXECUTING...                            ";
	int retval;
	SP<ByteBuffer> name;

	txt1[0] = 0x00;
	txt1[1] = 0x04;
	txt2[0] = 0x28;
	txt2[1] = 0x04;
	for (i=17;i<42;i++) txt1[i] = 0x20;
	for (i=0;i<42;i++) txt1[i] &= 0x3F;
	for (i=0;i<42;i++) txt2[i] &= 0x3F;

//	sDPrintF("RunFile %i\n", sel);

	if (cf) {
		name = cf->GetName();
		size = 16;
		for (i=0;i<size;i++) {
			if (name->GetByte(i) == 0) break;
			txt1[17+i] = name->GetByte(i) & 0x3F;
		}
		data = cf->GetData();
		size = cf->GetSize();
		if ((data) && (size > 2)) {
			retval = SendData(txt1, 42);
			if (retval < 0) {
				wcn->Close();
				wcn = 0;
				MessageBox(hwnd, "Could not send to C64!", "Error!",
					MB_ICONEXCLAMATION | MB_OK);
			}
			if (retval >= 0) {
				retval = SendData(txt2, 42);
			}
			if (retval >= 0) {
				retval = SendData(data, size);
			}
			if (retval >= 0) {
				n64->ExecRun();
			}
		}
		delete cf;
	}

	if (wcn) wcn->Close();
}


