#ifndef ___NETHOST_H___
#define ___NETHOST_H___

#include "global.h"

#ifdef WIN32

#ifndef WIN32_LEAN_AND_MEAN
	#define WIN32_LEAN_AND_MEAN 1
#endif
	#include <winsock2.h>

	typedef int socklen_t;

#else

	#ifdef __APPLE__
		#include <netinet/in.h>
	#endif

	#include <sys/types.h>
	#include <sys/socket.h>
	#include <netdb.h>
	#include <unistd.h>
	#include <arpa/inet.h>
	#include <sys/select.h>

	typedef int SOCKET;
	typedef struct sockaddr_in SOCKADDR_IN;
	#define SOCKET_ERROR            (-1)
	#define INVALID_SOCKET  (SOCKET)(~0)

#endif



#define NETHOST_OK		(1)
#define NETHOST_TIMEOUT	(0)
#define NETHOST_ERROR	(-1)

struct NetSocket
{
private:
	SOCKET Socket;

public:
	void Init(void);
	void Exit(void);

	SOCKET GetSocket(void) const;
};

struct NetHost
{
private:
	SOCKET Socket;
	SOCKADDR_IN Address;

public:
	void Init(const NetSocket *sock, const char *adr, uWORD prt);
	void Exit(void);

	int Send(uBYTE *buf, uLONG size);
	int Recv(uBYTE *buf, uLONG size, uLONG timeout);
};

#endif
