#include "petscii.h"

static char *pet2screen;
static char *pet2asc;
static char *pet2fname;
static char *tempstring;

void exitpetscii(void)
{
	delete[] pet2screen;
	delete[] pet2asc;
	delete[] pet2fname;
	delete[] tempstring;
}

static char gfx[0x21]=
{                     /* */
	"-|---||+++L\\/F7_V[+XO]++{|n\\"
};

static char gfx2[0x21]=
{                    /* */
	" |-_[#]m/]++++_++++[[]_J+++++"
};

static char gfx3[0x21]=
{
	"-ABCDEFGHIJKLMNOPQRSTUVWXYZ+||XX"
};

static char gfx4[0x21]=
{
	"@abcdefghijklmnopqrstuvwxyz[]^-"
};

static char p2fuc[0x21]=
{
	"-ABCDEFGHIJKLMNOPQRSTUVWXYZ+||XX"
};

static char p2flc[0x21]=
{
	"@abcdefghijklmnopqrstuvwxyz[]^"
};

static void setincremental(char *buffer, char start)
{
	int i;

	for (i=0; i<0x20; i++)
	{
		buffer[i] = start;
		start ++;
	}
}

static void setany(char *buffer, const char *data)
{
	unsigned int i;

	for (i=0; i<0x20; i++) buffer[i] = data[i];
}

void initpetscii(void)
{
	pet2screen = new char[256];
	pet2asc = new char[256];
	pet2fname = new char[256];
	tempstring = new char[1024];

	setincremental(&pet2screen[0x00], (char)0x80);
	pet2screen[0x0D] = (char)0x9F;
	setincremental(&pet2screen[0x20], 0x20);
	setincremental(&pet2screen[0x40], 0x00);
	setincremental(&pet2screen[0x60], 0x40);
	setincremental(&pet2screen[0x80], (char)0xC0);
	pet2screen[0x8D] = (char)0x9F;
	setincremental(&pet2screen[0xA0], 0x60);
	setincremental(&pet2screen[0xC0], 0x40);
	setincremental(&pet2screen[0xE0], 0x60);
	pet2screen[0xA0] = 0x20;
	pet2screen[0xFF] = 0x5E;


	setincremental(&pet2asc[0x00], 0x40);
	setincremental(&pet2asc[0x20], 0x20);
	setincremental(&pet2asc[0x40], 0x40);
	setany(&pet2asc[0x60], gfx);
	setany(&pet2asc[0x80], gfx);
	setany(&pet2asc[0xA0], gfx2);
	setany(&pet2asc[0xC0], gfx);
	setany(&pet2asc[0xE0], gfx2);

	pet2asc[0x1C] = '';
	pet2asc[0x1F] = '';
	pet2asc[0x5C] = '';
	pet2asc[0x5F] = '';

	pet2asc[0x0D] = '';
	pet2asc[0x8D] = '';
	pet2asc[0xFF] = 'n';

	setany(&pet2fname[0x00], p2flc);
	setincremental(&pet2fname[0x20], 0x20);
	setany(&pet2fname[0x40], p2flc);
	setany(&pet2fname[0x60], p2fuc);
	setany(&pet2fname[0x80], p2fuc);
	setincremental(&pet2fname[0xA0], 0x20);
	setany(&pet2fname[0xC0], p2fuc);
	setany(&pet2fname[0xE0], p2fuc);
	pet2fname[0x0D] = '';
	pet2fname[0x22] = '';
	pet2fname[0x2A] = '';
	pet2fname[0x2F] = '';
	pet2fname[0x3A] = '';
	pet2fname[0x3C] = '{';
	pet2fname[0x3E] = '}';
	pet2fname[0x3F] = '';
	pet2fname[0xBA] = '';
	pet2fname[0xE3] = '';
	pet2fname[0xE4] = '_';
	pet2fname[0xF7] = '~';


//00000ED0  9E 8B E4 78 86 60 35 14 E0 BF 5B D2 20 E2 E0 7F    x`5.[ 

/*
	setany(&pet2fname[0x00], gfx4);
	setincremental(&pet2fname[0x20], 0x20);
	setany(&pet2fname[0x40], gfx4);
	setany(&pet2fname[0x60], gfx3);
	setany(&pet2fname[0x80], gfx3);
	setany(&pet2fname[0xA0], gfx2);
	setany(&pet2fname[0xC0], gfx3);
	setany(&pet2fname[0xE0], gfx2);
*/
/*
	pet2fname[0x22] = '\'';
	pet2fname[0x23] = 'X';
	pet2fname[0x2F] = '-';
	pet2fname[0x3A] = '-';

	pet2fname[0xA2] = '\'';
	pet2fname[0xA3] = 'X';
	pet2fname[0xAF] = '-';
	pet2fname[0xBA] = '-';

	pet2fname[0xA6] = 'X';
	pet2fname[0xE6] = 'X';

	pet2fname[0xA9] = '-';
	pet2fname[0xE9] = '-';

	pet2fname[0x0D] = '-';
	pet2fname[0x8D] = '-';
	pet2fname[0xFF] = 'n';
*/
//	pet2fname[0x2F] = 
}

static char *petscii2any(unsigned char *string, unsigned int len, char *translation)
{
	unsigned int i;

	for (i=0; i<len; i++) tempstring[i] = translation[string[i]];
	tempstring[len] = 0;
	return tempstring;
}

void petscii2screen(unsigned char *string, int len)
{
	int i;

	for (i=0; i<len; i++) string[i] = pet2screen[string[i]];
}

void atascii2screen(unsigned char *string, int len)
{
	int i;
	unsigned char c;

	for (i=0; i<len; i++)
	{
		c = string[i];
		switch (c & 0x60)
		{
		case 0x00:
			string[i] = (c & 0x9F) | 0x40;
			break;
		case 0x20:
			string[i] = (c & 0x9F) | 0x00;
			break;
		case 0x40:
			string[i] = (c & 0x9F) | 0x20;
			break;
		case 0x60:
			string[i] = (c & 0x9F) | 0x60;
			break;
		}
	}
}

SP<ByteBuffer> filename2petscii(SP<StringStream> string)
{
	SP<ByteBuffer> buf;
	unsigned long i;
	char c;
	unsigned char tempstring[20];

	for (i=0;i<16;i++) tempstring[i] = (char)0xA0;
	tempstring[16] = 0;

	i = 0;
	while ((i<16) && (string->GetString()[i]))
	{
		c = string->GetString()[i];

		if ((c >= 'a') && (c <= 'z')) c = c - ('a' - 'A');

		switch (c)
		{
		case '':
//			c = 0xE3;
			c = 0x20;
			break;
		case '_':
//			c = 0xE4;
			c = 0x20;
			break;
		case '~':
//			c = 0xF7;
			c = 0x20;
			break;
		case '':
			c = 0x3A;
			break;
		case '':
			c = 0x5C;
			break;
		case '':
			c = 0x5F;
			break;
		case '':
			c = 0x2F;
			break;
		case '{':
			c = 0x3C;
			break;
		case '}':
			c = 0x3E;
			break;
		case '':
			c = 0x3F;
			break;
		case '':
			c = 0x22;
			break;
		case '':
			c = 0x2A;
			break;
		}

		tempstring[i] = c;
		i++;
	}

	buf = new ByteBuffer(tempstring, 16);

	return buf;
}

char *petscii2ascii(unsigned char *string, int len)
{
	return petscii2any(string, len, pet2asc);
}

SP<StringStream> petscii2filename(SP<ByteBuffer> name)
{
	int i, size;
	SP<StringStream> str;
	char tempstring[20];

	size = name->GetSize();
	if (size > 16) size = 16;

	for (i=0;i<size;i++) tempstring[i] = pet2fname[name->GetByte(i)];
	tempstring[size] = 0;
	i = size-1;
	while ((i >= 0) && (name->GetByte(i) == 0xA0))
	{
		tempstring[i] = 0;
		i--;
	}

	str = new StringStream(tempstring);

	return str;
}

