#ifndef __STRINGOPS_H__
#define __STRINGOPS_H__

/* some low-level string operations needed in other parts of the app  */
/* not quite oo-programming, but since strings are often used it's ok */

/********************************************************************************/

extern void initstringops(void);

/* compare: str1 < str2 (without case) */
//extern bool stringorder(const char *str1, const char *str2);

/* compare: str1 == str2 (without case) */
extern bool stringcmp(const char *str1, const char *str2);

/* compare: token == data (without case, data may end earlier than token) */
extern bool tokencmp(const char *token, const char *data);

/* length of a string in bytes, including 0-termination */
extern unsigned int stringlen(const char *string);

/* create a copy of that string, memory will be allocated */
extern char *copystring(const char *string);

/* parse a date-string */
//extern unsigned int parsedate(const char *string);

/* parse a date-string (ignore overflow on day and month) */
//extern unsigned int parsedatesafe(const char *string);

/* parse an integer value */
//extern unsigned int parseint(const char *string);

/* print an integer value */
extern unsigned int printint(char *string, unsigned int val);

/* print a string */
extern unsigned int printstring(char *string, char *prstr);

/* print a date */
//extern unsigned int printdatelimited(char *string, unsigned int date, unsigned int cmpdate);
//extern unsigned int printdate(char *string, unsigned int date);

#endif
