#ifndef __WINDOW_H__
#define __WINDOW_H__

#include <windows.h>
#include <ShellAPI.h>
#include "SmartPointer.h"

class CbmWindow
{
private:
public:
	HINSTANCE hInstance;
	HWND handle;
	bool visible;

	char *LoadFileName;
	char *DirFileName;

	SP<class FileImage> Image;

	struct NetArc *net;

	void *DDSurface;
	bool DDSurfaceAllocated;
	unsigned long col0, col1;

	void AllocSurface(struct CbmBitmap *bitmap);
	void FreeSurface();
	void RenderSurface(struct CbmBitmap *bitmap);

	unsigned char *selections;

	unsigned long entries;
	unsigned short lastselection;

	unsigned short zoom;
	unsigned long bitmapwidth;
	unsigned long bitmapheight;

	int scrollbar;

	void ClearSelections(void);
	void RemoveSelection(unsigned long index);
	unsigned long GetFirstSelection(void);

public:
	CbmWindow();
	~CbmWindow();

	void Init(HINSTANCE hInstance, struct NetArc *net);
	void Exit();
	void Show(SP<class FileImage> img);
	void Show(struct CbmBitmap *bitmap);
	void Redraw(bool newcontent);
	void CycleImage(bool forward);
	bool Drop(SP<class StringStream> path);
	void DropFiles(HDROP hdrop);
	void DisplayChange();

	void AddFileToImage(SP<class StringStream> path);

	bool SelectExclusive(unsigned short sel);
	bool SelectAdd(unsigned short sel);
	bool SelectBunch(unsigned short sel);
	void Select(unsigned short sel, bool control, bool shift);

	unsigned long GetWindowWidth();
	unsigned long GetWindowHeight();
	unsigned long GetPageHeight();

	bool DragOut(unsigned short sel);
	void RunFile(unsigned short sel);
	void NewImage(int type);
	void OpenImage(void);
	void SaveImage(bool svas);
	void SaveDir(void);

	void Create(HWND hwnd);
	void Notify(WPARAM wParam, LPARAM lParam);
	void KeyDown(WPARAM wParam);
	void Paint();
	void Size();

	void RefreshImageDisplay(void);
	void UpdateWindowHeight(void);

	unsigned long GetScrollPos();
	void RefreshScrollBar();
	void ResetScrollBar();
};

#endif
