#include "window.h"
#include "cbmlist.h"
#include "d64.h"
#include "atr.h"
#include "files.h"
#include "debug.h"
#include <ddraw.h>
#include "StringStream.h"

/**************************************************************************************/

#ifndef IID_IDirectDraw2
const GUID IID_IDirectDraw2 = { 0xB3A6F3E0, 0x2B43, 0x11CF,
                              { 0xA2, 0xDE, 0x00, 0xAA, 0x00, 0xB9, 0x33, 0x56}
                              };
#endif

static bool DirectDrawOpen = false;
static LPDIRECTDRAW DDObject = NULL;
static LPDIRECTDRAW2 DD2Interface = NULL;
static LPDIRECTDRAWSURFACE DDSPrimary = NULL;
static LPDIRECTDRAWCLIPPER DDCPrimary = NULL;

/**************************************************************************************/

bool OpenDirectDraw()
{
	HRESULT hresult;

	if (DirectDrawOpen) return true;

	hresult = DirectDrawCreate(NULL, &DDObject, NULL);
	if (hresult != DD_OK) {
		return false;
	}

	hresult = DDObject->SetCooperativeLevel(NULL, DDSCL_NORMAL);
	if (hresult != DD_OK) {
		DDObject->Release();
		return false;
	}

	hresult = DDObject->QueryInterface(IID_IDirectDraw2,(LPVOID *)&DD2Interface);
	if (hresult != DD_OK) {
		DDObject->Release();
		return false;
	}

	DirectDrawOpen = true;
	return true;
}

void CloseDirectDraw()
{
	if (!DirectDrawOpen) return;

	DD2Interface->Release();
	DDObject->Release();
	DirectDrawOpen = false;
}

static void AttachClipper(LPDIRECTDRAWSURFACE *surface, LPDIRECTDRAWCLIPPER *clipper)
{
    HRESULT hresult;

    hresult = DD2Interface->CreateClipper(0, clipper, NULL);
    if (hresult != DD_OK) {
//		sDPrintF("No clipper\n");
		return;
    }
    hresult = (*surface)->SetClipper(*clipper);
    if (hresult != DD_OK) {
    }
}

bool OpenPrimarySurface()
{
	HRESULT hresult;
    DDSURFACEDESC desc;

    memset(&desc, 0, sizeof(desc));
    desc.dwSize = sizeof(desc);
    desc.dwFlags = DDSD_CAPS;
    desc.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;
	hresult = DD2Interface->CreateSurface(&desc, &DDSPrimary, NULL);
	if (hresult != DD_OK)
	{
		MessageBox(NULL, "Could not create primary surface!", "Error!",
			MB_ICONEXCLAMATION | MB_OK);
		return false;
	}
	AttachClipper(&DDSPrimary, &DDCPrimary);
	return true;
}

void ClosePrimarySurface()
{
	if (DDCPrimary) DDCPrimary->Release();
	if (DDSPrimary) DDSPrimary->Release();
}

/**************************************************************************************/

extern const char *Arc64_DefaultTitle;

void CbmWindow::Redraw(bool newcontent)
{
	RECT rect;
	RECT srect;
	CbmList *list;
	CbmBitmap *bitmap;
	HRESULT hr;
	SP<StringStream> infotext;

	if (newcontent)
	{
		if (Image != 0) list = Image->GetDirectory();
		else return;

		if (!list) return;
		bitmap = list->GetBitmap();
		list->Exit();
		delete[] list;

		infotext = getfilename(Image->GetInfoText());
		if (infotext->GetSize() == 0) infotext = new StringStream(Arc64_DefaultTitle);

		if (Image != 0) SetWindowText(handle, infotext->GetString());
		else SetWindowText(handle, 0);

		entries = bitmap->GetHeight() >> 3;

		RenderSurface(bitmap);

		bitmapwidth = bitmap->GetWidth();
		bitmapheight = bitmap->GetHeight();
//		SetWindowPos(handle, 0, 0, 0, GetWindowWidth(), GetWindowHeight(), SWP_NOZORDER | SWP_NOMOVE | SWP_NOCOPYBITS);

		bitmap->Exit();
		delete[] bitmap;
	}

    GetClientRect(handle, &rect);
	ClientToScreen(handle, (LPPOINT) &rect);
	DDCPrimary->SetHWnd(0, handle);

	srect.left = 0;
	srect.top = GetScrollPos();
	srect.right = rect.right;
	srect.bottom = rect.bottom+srect.top;

	rect.right += rect.left;
	rect.bottom += rect.top;

//	srect.right -= GetSystemMetrics(SM_CXVSCROLL);
//	rect.right -= GetSystemMetrics(SM_CXVSCROLL);

//	srect.right = 256;
//	srect.bottom = srect.top+((rect.bottom-rect.top)*(srect.right-srect.left))/(rect.right-rect.left);

	hr = DDSPrimary->Blt(&rect, (LPDIRECTDRAWSURFACE)DDSurface, &srect, DDBLT_ASYNC, NULL);
	if (hr == DDERR_SURFACELOST)
	{
		DDSPrimary->Restore();
		hr = DDSPrimary->Blt(&rect, (LPDIRECTDRAWSURFACE)DDSurface, &srect, DDBLT_ASYNC, NULL);
	}
}

void CbmWindow::AllocSurface(CbmBitmap *bitmap)
{
    HRESULT hresult;
    DDSURFACEDESC desc;
    DDSURFACEDESC modedesc;
	LPDIRECTDRAWSURFACE surface;
	RECT rect;
	DDBLTFX bltfx;
	HDC hdc;
	unsigned long height;

	FreeSurface();

    memset(&modedesc, 0, sizeof(modedesc));
    modedesc.dwSize = sizeof(modedesc);
    hresult = DD2Interface->GetDisplayMode(&modedesc);

	height = (bitmap->GetHeight() + 8)*zoom;
	if (modedesc.dwHeight > height) height = modedesc.dwHeight;

	memset(&desc, 0, sizeof(desc));
    desc.dwSize = sizeof(desc);
    desc.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
	desc.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_SYSTEMMEMORY;
	desc.dwWidth = bitmap->GetWidth()*zoom;
	desc.dwHeight = height;
//	desc.dwHeight = modedesc.dwHeight;
	hresult = DD2Interface->CreateSurface(&desc, &surface, NULL);
	DDSurface = (LPDIRECTDRAWSURFACE)surface;
	if (hresult != DD_OK)
	{
		MessageBox(NULL, "Could not create temporary surface!", "Error!",
			MB_ICONEXCLAMATION | MB_OK);
	}
	else
	{
		hresult = surface->Lock(NULL, &desc, DDLOCK_SURFACEMEMORYPTR | DDLOCK_WAIT, NULL);
		if (hresult == DDERR_SURFACELOST)
		{
			surface->Restore();
			hresult = surface->Lock(NULL, &desc, DDLOCK_SURFACEMEMORYPTR | DDLOCK_WAIT, NULL);
		}
		surface->Unlock(desc.lpSurface);

		hresult = surface->GetDC(&hdc);
		if (hresult == DD_OK)
		{
			SetPixelV(hdc, 0, 0, 0x00FFFFFF);
			SetPixelV(hdc, 1, 0, 0x00000000);

			switch (desc.ddpfPixelFormat.dwRGBBitCount)
			{
			default:
				col0 = 0x00FFFFFF;
				col1 = 0x00000000;
				break;
			case 8:
				col0 = ((unsigned char *)desc.lpSurface)[0];
				col1 = ((unsigned char *)desc.lpSurface)[1];
				break;
			case 16:
				col0 = ((unsigned short *)desc.lpSurface)[0];
				col1 = ((unsigned short *)desc.lpSurface)[1];
				break;
			case 32:
				col0 = ((unsigned long *)desc.lpSurface)[0];
				col1 = ((unsigned long *)desc.lpSurface)[1];
				break;
			}
			surface->ReleaseDC(hdc);
		}

		rect.left = 0;
		rect.top = 0;
		rect.right = desc.dwWidth;
		rect.bottom = desc.dwHeight;
		memset(&bltfx, 0, sizeof(bltfx));
		bltfx.dwSize = sizeof(bltfx);
		bltfx.dwFillColor = 0x00FFFFFF;
		surface->Blt(&rect, 0, 0, DDBLT_WAIT | DDBLT_COLORFILL, &bltfx);
	}
}

void CbmWindow::FreeSurface()
{
	if (DDSurfaceAllocated)
	{
		DDSurfaceAllocated = false;
		((LPDIRECTDRAWSURFACE)DDSurface)->Release();
		DDSurface = 0;
	}
}

void CbmWindow::RenderSurface(CbmBitmap *bitmap)
{
    HRESULT hresult;
	DDSURFACEDESC desc;
	HDC hdc;
	unsigned long col, c0, c1, pitch, x, y;
	LPDIRECTDRAWSURFACE surface;
	RECT rect;
	DDBLTFX bltfx;
	unsigned char *surflp;

	AllocSurface(bitmap);

	memset(&desc, 0, sizeof(desc));
	desc.dwSize = sizeof(desc);

	surface = (LPDIRECTDRAWSURFACE)DDSurface;

	hresult = surface->Lock(NULL, &desc, DDLOCK_SURFACEMEMORYPTR | DDLOCK_WAIT, NULL);
	if (hresult == DDERR_SURFACELOST)
	{
		surface->Restore();
		hresult = surface->Lock(NULL, &desc, DDLOCK_SURFACEMEMORYPTR | DDLOCK_WAIT, NULL);
	}
	surface->Unlock(desc.lpSurface);

	if (hresult == DD_OK)
	{
		rect.left = 0;
		rect.top = 0;
		rect.right = bitmap->GetWidth()*zoom;
		rect.bottom = desc.dwHeight;
		memset(&bltfx, 0, sizeof(bltfx));
		bltfx.dwSize = sizeof(bltfx);
		bltfx.dwFillColor = 0x00FFFFFF;
		surface->Blt(&rect, 0, 0, DDBLT_WAIT | DDBLT_COLORFILL, &bltfx);

		pitch = desc.lPitch;

		switch (desc.ddpfPixelFormat.dwRGBBitCount)
		{
		default:
			hresult = surface->GetDC(&hdc);
			if (hresult == DD_OK)
			{
				if (zoom == 1)
				{
					for (y=0;y<bitmap->GetHeight();y++)
					{
						if (selections[y >> 3])
						{
							c0 = col0;
							c1 = col1;
						}
						else
						{
							c0 = col1;
							c1 = col0;
						}
						surflp = (unsigned char *)desc.lpSurface + (pitch*y);

						for (x=0;x<bitmap->GetWidth();x++)
						{
							if (!bitmap->GetPixelFast(x,y)) col = c1;
							else col = c0;
							SetPixelV(hdc, x, y, col);
						}
					}
				}
				else
				{
					for (y=0;y<bitmap->GetHeight();y++)
					{
						if (selections[y >> 3])
						{
							c0 = col0;
							c1 = col1;
						}
						else
						{
							c0 = col1;
							c1 = col0;
						}
						surflp = (unsigned char *)desc.lpSurface + (pitch*y*2);

						for (x=0;x<bitmap->GetWidth();x++)
						{
							if (!bitmap->GetPixelFast(x,y)) col = c1;
							else col = c0;
							SetPixelV(hdc, x+x, y+y, col);
							SetPixelV(hdc, x+x+1, y+y, col);
							SetPixelV(hdc, x+x, y+y+1, col);
							SetPixelV(hdc, x+x+1, y+y+1, col);
						}
					}
				}
				surface->ReleaseDC(hdc);
			}
			break;
		case 8:
			if (zoom == 1)
			{
				for (y=0;y<bitmap->GetHeight();y++)
				{
					if (selections[y >> 3])
					{
						c0 = col0;
						c1 = col1;
					}
					else
					{
						c0 = col1;
						c1 = col0;
					}
					surflp = (unsigned char *)desc.lpSurface + (pitch*y);

					for (x=0;x<bitmap->GetWidth();x++)
					{
						if (!bitmap->GetPixelFast(x,y)) col = c1;
						else col = c0;
						((unsigned char *)surflp)[0] = (unsigned char)col;
						surflp ++;
					}
				}
			}
			else
			{
				for (y=0;y<bitmap->GetHeight();y++)
				{
					if (selections[y >> 3])
					{
						c0 = col0;
						c1 = col1;
					}
					else
					{
						c0 = col1;
						c1 = col0;
					}
					surflp = (unsigned char *)desc.lpSurface + (pitch*y*2);

					for (x=0;x<bitmap->GetWidth();x++)
					{
						if (!bitmap->GetPixelFast(x,y)) col = c1;
						else col = c0;
						((unsigned char *)surflp)[0] = (unsigned char)col;
						((unsigned char *)surflp)[1] = (unsigned char)col;
						surflp += pitch;
						((unsigned char *)surflp)[0] = (unsigned char)col;
						((unsigned char *)surflp)[1] = (unsigned char)col;
						surflp -= pitch-2;
					}
				}
			}
			break;
		case 16:
			if (zoom == 1)
			{
				for (y=0;y<bitmap->GetHeight();y++)
				{
					if (selections[y >> 3])
					{
						c0 = col0;
						c1 = col1;
					}
					else
					{
						c0 = col1;
						c1 = col0;
					}
					surflp = (unsigned char *)desc.lpSurface + (pitch*y);

					for (x=0;x<bitmap->GetWidth();x++)
					{
						if (!bitmap->GetPixelFast(x,y)) col = c1;
						else col = c0;
						((unsigned short *)surflp)[0] = (unsigned short)col;
						surflp += 2;
					}
				}
			}
			else
			{
				for (y=0;y<bitmap->GetHeight();y++)
				{
					if (selections[y >> 3])
					{
						c0 = col0;
						c1 = col1;
					}
					else
					{
						c0 = col1;
						c1 = col0;
					}
					surflp = (unsigned char *)desc.lpSurface + (pitch*y*2);

					for (x=0;x<bitmap->GetWidth();x++)
					{
						if (!bitmap->GetPixelFast(x,y)) col = c1;
						else col = c0;
						((unsigned short *)surflp)[0] = (unsigned short)col;
						((unsigned short *)surflp)[1] = (unsigned short)col;
						surflp += pitch;
						((unsigned short *)surflp)[0] = (unsigned short)col;
						((unsigned short *)surflp)[1] = (unsigned short)col;
						surflp -= pitch-4;
					}
				}
			}
			break;
		case 32:
			if (zoom == 1)
			{
				for (y=0;y<bitmap->GetHeight();y++)
				{
					if (selections[y >> 3])
					{
						c0 = col0;
						c1 = col1;
					}
					else
					{
						c0 = col1;
						c1 = col0;
					}
					surflp = (unsigned char *)desc.lpSurface + (pitch*y);

					for (x=0;x<bitmap->GetWidth();x++)
					{
						if (!bitmap->GetPixelFast(x,y)) col = c1;
						else col = c0;
						((unsigned long *)surflp)[0] = col;
						surflp += 4;
					}
				}
			}
			else
			{
				for (y=0;y<bitmap->GetHeight();y++)
				{
					if (selections[y >> 3])
					{
						c0 = col0;
						c1 = col1;
					}
					else
					{
						c0 = col1;
						c1 = col0;
					}
					surflp = (unsigned char *)desc.lpSurface + (pitch*y*2);

					for (x=0;x<bitmap->GetWidth();x++)
					{
						if (!bitmap->GetPixelFast(x,y)) col = c1;
						else col = c0;
						((unsigned long *)surflp)[0] = col;
						((unsigned long *)surflp)[1] = col;
						surflp += pitch;
						((unsigned long *)surflp)[0] = col;
						((unsigned long *)surflp)[1] = col;
						surflp -= pitch-8;
					}
				}
			}
			break;
		}

	}
}

void CbmWindow::DisplayChange()
{
//	AllocSurface();
}
