#include "argstream.h"
#include "stringops.h"

ArgStreamReader::ArgStreamReader(char *stream)
{
	Position = 0;
	Stream = stream;
	Word = 0;
}

ArgStreamReader::~ArgStreamReader(void)
{
	if (Word) delete[] Word;
}

void ArgStreamReader::SkipDelimiters(void)
{
	while ((Stream[Position] <= 0x20) && (Stream[Position] > 0)) Position++;
}

char *ArgStreamReader::GetWord(void)
{
	long i, k;

	SkipDelimiters();
	if (AtEnd()) return 0;

	i = 0;
	if (Stream[Position] == 0x22) {
		Position++;
		while ((Stream[Position+i] != 0) && (Stream[Position+i] != 0x22)) i++;
		if (Word) delete[] Word;
		Word = new char[i+1];
		for (k=0;k<i;k++) Word[k] = Stream[Position+k];
		Word[i] = 0;
		Position += i;
		if (Stream[Position] == 0x22) Position++;
	} else {
		while ((Stream[Position+i] > 0x20) || (Stream[Position+i] < 0)) i++;
		if (Word) delete[] Word;
		Word = new char[i+1];
		for (k=0;k<i;k++) Word[k] = Stream[Position+k];
		Word[i] = 0;
		Position += i;
	}
	SkipDelimiters();
	return Word;
}

int ArgStreamReader::AtEnd(void)
{
	if (!Stream) return 1;
	if (!Stream[Position]) return 1;
	return 0;
}

int ArgStreamReader::GetToken(ArgToken *tokens, char *string)
{
	long i;

	i = 0;
	while (tokens[i].Token) {
		if (stringcmp(tokens[i].String, string)) return (tokens[i].Token);
		i++;
	}
	return (0);
}


ArgStream::ArgStream(char **args, int argc, ArgToken *tkn)
{
	Arguments = args;
	ArgCount = argc;
	ArgPosition = 0;
	Tokens = tkn;
}

//void ArgStream::Init(char *cmdline)
//{
//}

ArgStream::~ArgStream(void)
{
}

int ArgStream::HasArguments(void)
{
	return (ArgPosition < ArgCount);
}

char *ArgStream::GetNext(void)
{
	if (!HasArguments()) return 0;

	return (Arguments[ArgPosition++]);
}

char *ArgStream::Peek(void)
{
	if (!HasArguments()) return 0;

	return (Arguments[ArgPosition]);
}

int ArgStream::GetNextToken(void)
{
	int i;
	char *arg;

	arg = GetNext();
	i = 0;
	if (!arg)
	{
		while (Tokens[i].String) i++;
	} else {
		while (Tokens[i].String)
		{
			if (stringcmp(Tokens[i].String, arg)) break;
			i++;
		}
	}
	return Tokens[i].Token;
}
