#include "ByteBuffer.h"
#include "StringStream.h"
#include "debug.h"

#ifdef _DEBUG
static int bufcounter;
#endif

void ByteBuffer::Construct(const unsigned char *buffer, int size)
{
	int i;

	if (buffer == 0) {
		Buffer = 0;
		Size = 0;
	} else {
		Size = size;
		Buffer = new unsigned char[Size];
		for (i=0;i<Size;i++) Buffer[i] = buffer[i];
	}

#ifdef _DEBUG
	bufcounter++;
	sDPrintF("ByteBuffer %i\n", bufcounter);
#endif
}

ByteBuffer::ByteBuffer(void)
{
	Construct(0, 0);
}

ByteBuffer::ByteBuffer(const unsigned char *buf, int siz)
{
	Construct(buf, siz);
}

ByteBuffer::ByteBuffer(SP<StringStream> str)
{
	Construct((unsigned char *)(str->GetString()), str->GetSize());
}

ByteBuffer::~ByteBuffer(void)
{
	if (Buffer) delete[] Buffer;

#ifdef _DEBUG
	bufcounter--;
	sDPrintF("ByteBuffer %i\n", bufcounter);
#endif
}

unsigned char *ByteBuffer::GetBuffer(void)
{
	return (Buffer);
}

int ByteBuffer::GetSize(void)
{
	return (Size);
}

unsigned char ByteBuffer::GetByte(int index)
{
	if ((index >= 0) && (index < Size)) return Buffer[index];

	return 0;
}

void ByteBuffer::SetByte(unsigned char byte, int index)
{
	if ((index >= 0) && (index < Size)) Buffer[index] = byte;
}

void ByteBuffer::Put(unsigned char *target)
{
	int i;

	for (i=0;i<Size;i++) target[i] = Buffer[i];
}

