#ifndef ___DIRENTRY_H___
#define ___DIRENTRY_H___

#include "SmartPointer.h"
#include "StringStream.h"
#include "ByteBuffer.h"

struct DirEntryHeader
{
public:
	unsigned char *Entry;

	DirEntryHeader *DeepCopy(void);
	void SetEntry(DirEntryHeader *entry);
	void Exit(void);

	SP<StringStream> GetHeaderASCII(void);
	void SetHeaderASCII(SP<StringStream> filename);
	SP<StringStream> GetIdASCII(void);
	void SetIdASCII(SP<StringStream> filename);

	void SetProtection(bool protection);
	bool GetProtection(void);
	unsigned short GetBlockCount(void);
	void SetBlockCount(unsigned short blocks);
};

struct DirEntryD64
{
public:
	unsigned char *Entry;

	DirEntryD64 *DeepCopy(void);
	void SetEntry(DirEntryD64 *entry);
	void Exit(void);

	SP<StringStream> GetFileNameASCII(void);
	void SetFileNameASCII(SP<StringStream> filename);

	void SetFileType(unsigned char filetype);
	unsigned char GetFileType(void);
	void SetProtection(bool protection);
	bool GetProtection(void);
	void SetClosed(bool closed);
	bool GetClosed(void);
	unsigned short GetBlockCount(void);
	void SetBlockCount(unsigned short blocks);
};

struct DirEntryATR
{
public:
	unsigned char *Entry;

	DirEntryATR *DeepCopy(void);
	void SetEntry(DirEntryATR *entry);
	void Exit(void);

	SP<StringStream> GetFileNameASCII(void);
	void SetFileNameASCII(SP<StringStream> filename);

	bool IsNeverUsed(void);
	void SetLocked(bool protection);
	bool GetLocked(void);
	void SetOpened(bool closed);
	bool GetOpened(void);
	void SetDeleted(bool protection);
	bool GetDeleted(void);
	void SetInUse(bool inuse);
	bool GetInUse(void);
	void SetDOS2(bool dos2);
	bool GetDOS2(void);
	unsigned short GetBlockCount(void);
	void SetBlockCount(unsigned short blocks);
};

#endif
