#include "Executable.h"
#include "stringops.h"

#include "process.h"

Executable::Executable(char *path)
{
	Arguments = 0;
	Count = 0;
	AddArgument(path);
}

Executable::~Executable(void)
{
	unsigned int i;

	if (Arguments) {
		for (i=0;i<Count;i++) delete[] Arguments[i];
		delete[] Arguments;
	}
}

void Executable::AddArgument(const char *arg)
{
	unsigned int i;
	unsigned int k;
	char **newargs;
	char *newstr;
	int hasspaces;

	if (arg == 0) return;

	newargs = new char *[Count+2];	// allocate one more for NULL termination
	if (Arguments) {
		for (i=0;i<Count;i++) newargs[i] = Arguments[i];
	}

	hasspaces = 0;
	i = 0;
	while (arg[i] != 0) {
		hasspaces |= (arg[i] == 0x20);
		i++;
	}
	if (hasspaces) i += 2;

	newstr = new char[i+1];
	k = 0;
	if (hasspaces) newstr[k++] = '\"';

	i = 0;
	while (arg[i] != 0) {
		newstr[k++] = arg[i++];
	}

	if (hasspaces) newstr[k++] = '\"';
	newstr[k] = 0;

	newargs[Count] = newstr;
	newargs[Count+1] = 0;			// NULL termination
	delete[] Arguments;
	Arguments = newargs;
	Count++;
}

void Executable::AddArgument(SP<StringStream> arg)
{
	AddArgument(arg->GetString());
}

int Executable::Spawn(bool wait)
{
	int mode, err;

	if (wait) mode = _P_WAIT;
	else mode = _P_NOWAIT;
	err = _spawnvp(mode, Arguments[0], Arguments);

	return (err == -1);
}
