#ifndef ___FILECONTAINER_H___
#define ___FILECONTAINER_H___

#include "SmartPointer.h"

class FileContainer
{
private:
	SP<class StringStream> Path;
	SP<class ByteBuffer> Header;

	class C64File **Entries;
	int Count;

public:
	FileContainer(void);
	FileContainer(SP<class StringStream> path);
	~FileContainer(void);

	void SetHeader(SP<class ByteBuffer> head);
	SP<class ByteBuffer> GetHeader(void);
	SP<class StringStream> GetPath(void);

	void Add(class C64File *file);
	bool AddTo(class FileImage *img);
};

class FileContainer *ParseFile(SP<class StringStream> path, int type, const unsigned char *data, int size);

#endif
