#include "FileP00.h"
#include "c64file.h"
#include "FileContainer.h"

static unsigned char p00magic[8] = "C64File";

class FileContainer *ParseP00(SP<class StringStream> path, unsigned char type, const unsigned char *data, int size)
{
	class FileContainer *fc;
	unsigned char *fdata;
	unsigned char name[16];
	unsigned char c;
	int i;
	bool test;

	// P00 header size: 26 bytes
	if ((size < 26) || (data == 0)) return (0);

	// check P00 signature
	test = true;
	for (i=0;i<8;i++) test &= (data[i] == p00magic[i]);
	if (!test) return (0);

	// convert filename to D64-compatible format
	for (i=0;i<16;i++) {
		c = data[i+8];
		if (c == 0) c = 0xA0;
		name[i] = c;
	}

	data += 26;
	size -= 26;
	fdata = new unsigned char[size];
	for (i=0;i<size;i++) fdata[i] = data[i];

	// create filecontainer and add P00 file
	fc = new FileContainer(path);
	fc->Add(new C64File(new ByteBuffer(name, 16), fdata, size, 0x82, FILEFORMAT_CBM));
	return (fc);
}
