#ifndef ___GLOBALCONFIG_H___
#define ___GLOBALCONFIG_H___

#include "SmartPointer.h"

#define CONFIG_DEFAULTIMAGE_NULL	0
#define CONFIG_DEFAULTIMAGE_D64		1
#define CONFIG_DEFAULTIMAGE_ATR		2

class GlobalConfig
{
private:
	SP<class StringStream> Path;

	int Changed;

	SP<class StringStream> IP;
	int Port;

	int DefaultImage;

	SP<class StringStream> X64Path;
	SP<class StringStream> X128Path;
	SP<class StringStream> XVICPath;
	SP<class StringStream> XPLUS4Path;
	SP<class StringStream> YAPEPath;
	SP<class StringStream> A800WPath;


public:
	int UseTrack18;
	int DirTrack18Only;
	int Interleave;
	int DirInterleave;
	int Strategy;

	GlobalConfig(SP<class StringStream> filepath);
	~GlobalConfig(void);

	void SetIP(SP<class StringStream> str);
	void SetNetPort(int p);
	void SetDefaultImage(int d);
	void SetX64Path(SP<class StringStream> str);
	void SetX128Path(SP<class StringStream> str);
	void SetXVICPath(SP<class StringStream> str);
	void SetXPLUS4Path(SP<class StringStream> str);
	void SetYAPEPath(SP<class StringStream> str);
	void SetA800WPath(SP<class StringStream> str);

	SP<class StringStream> GetIP(void);
	int GetNetPort(void);
	SP<StringStream> GetX64Path(void);
	SP<StringStream> GetX128Path(void);
	SP<StringStream> GetXVICPath(void);
	SP<StringStream> GetXPLUS4Path(void);
	SP<StringStream> GetYAPEPath(void);
	SP<StringStream> GetA800WPath(void);

	SP<class FileImage> Load(void);
	void Save(void);
	SP<class FileImage> ParseCmds(SP<class FileImage> fd64, char *cmdline);
};

SP<class FileImage> ParseSettings(class GlobalConfig *config, char *filename);

extern class GlobalConfig *Config;

#endif
