#ifndef ___SMARTPOINTER_H___
#define ___SMARTPOINTER_H___

class RC
{
public:
	int ReferenceCounter;

public:
	RC()
	{
		ReferenceCounter = 0;
	}

	~RC()
	{
	}

	void AddReference()
	{
		ReferenceCounter++;
	}

	int ReleaseReference()
	{
		ReferenceCounter--;

		return (ReferenceCounter);
	}

	int GetCount(void)
	{
		return (ReferenceCounter);
	}
};

template < typename T > class SP
{
private:
	T* SmartPointer;
	RC* ReferenceCounter;

public:
	SP()
	{
		SmartPointer = 0;
		ReferenceCounter = new RC();
		ReferenceCounter->AddReference();
	}
    
	SP(T* pointer)
	{
		SmartPointer = pointer;
		ReferenceCounter = new RC();
		ReferenceCounter->AddReference();
	}

	SP(const SP<T>& sp)
	{
		SmartPointer = sp.SmartPointer;
		ReferenceCounter = sp.ReferenceCounter;
		ReferenceCounter->AddReference();
	}

	~SP()
	{
		if (ReferenceCounter->ReleaseReference() == 0)
		{
			delete SmartPointer;
			delete ReferenceCounter;
		}
	}

	T& operator* ()
	{
		return *SmartPointer;
	}
    
	T* operator-> ()
	{
		return SmartPointer;
	}
    
	SP<T>& operator = (const SP<T>& sp)
	{
		if (this != &sp)
		{
			if (ReferenceCounter->ReleaseReference() == 0)
			{
				delete SmartPointer;
				delete ReferenceCounter;
			}

			SmartPointer = sp.SmartPointer;
			ReferenceCounter = sp.ReferenceCounter;
			ReferenceCounter->AddReference();
		}
		return *this;
	}

	bool operator== (const SP<T>& sp)
	{
		return (SmartPointer == sp.SmartPointer);
	}

	bool operator!= (const SP<T>& sp)
	{
		return (SmartPointer != sp.SmartPointer);
	}

	T* GetNativePointer()
	{
		return (SmartPointer);
	}
};

#endif
