#include "StringContainer.h"
#include "stringops.h"

StringContainer::StringContainer(void)
{
	Count = 0;
	Allocated = 16;
	Strings = new char*[Allocated];
}

StringContainer::~StringContainer(void)
{
	int i;

	if (Strings != 0) {
		for (i=0;i<Count;i++) {
			if (Strings[i] != 0) delete[] Strings[i];
		}
		delete[] Strings;
	}
}

int StringContainer::GetCount(void)
{
	return (Count);
}

char *StringContainer::Get(int index)
{
	if ((index < 0) || (index >= Count)) return (0);

	return Strings[index];
}

void StringContainer::Add(const char *str)
{
	int i, len;
	char *copy;
	char **ns;

	if (str == 0) return;

	if (Allocated <= Count) {
		Allocated += (Allocated >> 1);
		ns = new char*[Allocated];
		for (i=0;i<Count;i++) ns[i] = Strings[i];
		delete[] Strings;
		Strings = ns;
	}

	len = stringlen(str)+1;
	copy = new char[len];
	for (i=0;i<len;i++) copy[i] = str[i];

	Strings[Count] = copy;
	Count++;
}

char *StringContainer::GetAll(void)
{
	int i, k, size;
	char *trg;
	char *str;
	char *all;

	size = 0;
	for (i=0;i<Count;i++) {
		if (Strings[i]) size += stringlen(Strings[i])+1;
	}
	all = new char[size+1];

	trg = all;
	size = 0;
	for (i=0;i<Count;i++) {
		str = Strings[i];
		if (str) {
			size = stringlen(str)+1;
			for (k=0;k<size;k++) *trg++ = *str++;
		}
	}
	*trg = 0;

	return (all);
}
