#ifndef __STRINGSTREAM_H__
#define __STRINGSTREAM_H__

#include "SmartPointer.h"

class StringStream
{
private:
	char *String;
	int Size;

	void Construct(const char *string);

public:
	StringStream(void);
	StringStream(int value);
	StringStream(const char *string);
	StringStream(SP<class ByteBuffer> bb);
	StringStream(SP<class StringStream> str);
	~StringStream(void);

	char *GetString(void);
	int GetSize(void);
	char GetChar(int index);

	SP<StringStream> Append(const char *string);
	SP<StringStream> Append(SP<StringStream> string);

	int ParseInteger(void);

	int IsEqual(SP<StringStream> str);

	SP<StringStream> Cut(int index);
	SP<StringStream> GetExtension(void);
};

#endif
