#include "Win32_ComboBox.h"

extern void CreateControl(HWND parent, int label, unsigned int style, char *wclass, char *text, unsigned int flags);

ComboBox::ComboBox(HWND parent, HINSTANCE hInstance, char **list, int defsel)
{
	int i;

	CreateControl(parent, hInstance, "COMBOBOX",
		WS_CHILD | WS_VISIBLE | WS_BORDER | CBS_DROPDOWNLIST, 0, 0);

	i = 0;
	while (list[i]) {
		SendMessage(Handle, CB_ADDSTRING, 0, (LPARAM)list[i]);
		i++;
	}
	SendMessage(Handle, CB_SETCURSEL, (WPARAM) defsel, 0);
}

int ComboBox::GetSelection(void)
{
	int sel;

	sel = -1;
	if (Handle) {
		sel = SendMessage(Handle, CB_GETCURSEL, 0, 0);
		if (sel == CB_ERR) sel = -1;
	}
	return (sel);
}

void ComboBox::SetSelection(int sel)
{
	if (Handle) SendMessage(Handle, CB_SETCURSEL, (WPARAM) sel, 0);
}
