#include "Win32_ControlGadget.h"

static char TextBuffer[512];

ControlGadget::ControlGadget(void)
{
}

void ControlGadget::Init(int wid, int hei)
{
	PosX = 0;
	PosY = 0;
	Width = wid;
	Height = hei;
}

void ControlGadget::CreateControl(HWND parent, HINSTANCE instance, LPCTSTR classname, DWORD style, int wid, int hei)
{
//	HFONT font;

	PosX = 0;
	PosY = 0;
	Width = wid;
	Height = hei;

	Handle = CreateWindow(classname, NULL,
		style, 0, 0, Width, Height, parent, NULL, instance, NULL);

//	font = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
//	SendMessage(Handle, WM_SETFONT, (WPARAM)font, MAKELPARAM(FALSE, 0));
}

ControlGadget::~ControlGadget(void)
{
	if (Handle) {
		DestroyWindow(Handle);
	}
}

void ControlGadget::SetPos(int x, int y)
{
	PosX = x;
	PosY = y;
	if (Handle) SetWindowPos(Handle, NULL, x, y, 0, 0, SWP_NOZORDER | SWP_NOSIZE);
}

void ControlGadget::SetPos(int x, int y, int wid, int hei)
{
	PosX = x;
	PosY = y;
	Width = wid;
	Height = hei;

	if (Handle) SetWindowPos(Handle, NULL, x, y, wid, hei, SWP_NOZORDER);
}

void ControlGadget::Update(HWND hwnd)
{
	RECT updaterect;
	RECT rect;
	BOOL update;

	if (Handle) {
		update = GetUpdateRect(Handle, &updaterect, 0);
		if (update) {
			UpdateWindow(Handle);
			GetWindowRect(Handle, &rect);
			ValidateRect(Handle, &rect);
//			ValidateRect(Handle, &updaterect);
		}
	}
}

void ControlGadget::Destroy(void)
{
	if (Handle) {
		DestroyWindow(Handle);
		Handle = 0;
	}
}

int ControlGadget::IsControl(HWND hwnd)
{
	return (Handle == hwnd);
}

int ControlGadget::GetWidth(void)
{
	return Width;
}

int ControlGadget::GetHeight(void)
{
	return Height;
}

void ControlGadget::ExcludeFrom(HDC hdc)
{
	ExcludeClipRect(hdc, PosX, PosY, Width+PosX, Height+PosY);
}

SP<StringStream> ControlGadget::GetText(void)
{
	int len;
	char *buffer;
	SP<StringStream> text;

	if (Handle) {
		len = SendMessage(Handle, WM_GETTEXTLENGTH, 0, 0);
		buffer = new char[len+1];
		SendMessage(Handle, WM_GETTEXT, (WPARAM) (len+1), (LPARAM) buffer);
		text = new StringStream(buffer);
		delete[] buffer;
	} else {
		text = new StringStream();
	}

	return (text);
}

void ControlGadget::SetText(SP<StringStream> string)
{
	if (Handle) SendMessage(Handle, WM_SETTEXT, (WPARAM) (string->GetSize()), (LPARAM) (string->GetString()));
}
