#ifndef ___WIN32_CONTROLGADGET_H___
#define ___WIN32_CONTROLGADGET_H___

#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
#endif

#include <windows.h>

#include "SmartPointer.h"
#include "StringStream.h"

class ControlGadget
{
protected:
	HWND Handle;
	int PosX;
	int PosY;
	int Width;
	int Height;

	void Init(int wid, int hei);
	void CreateControl(HWND parent, HINSTANCE instance, LPCTSTR classname, DWORD style, int wid, int hei);

public:
	ControlGadget(void);
	virtual ~ControlGadget(void);

	void SetPos(int x, int y);
	void SetPos(int x, int y, int wid, int hei);
	void Update(HWND hwnd);
	void Destroy(void);
	int IsControl(HWND hwnd);

	int GetWidth(void);
	int GetHeight(void);
	void ExcludeFrom(HDC hdc);
	void SetText(SP<StringStream> string);
	SP<StringStream> GetText(void);
};

#endif
