#include "Win32_EditControl.h"
#include "stringops.h"

EditControl::EditControl(HWND parent, HINSTANCE hInstance, SP<StringStream> string)
{
	PosX = 0;
	PosY = 0;
	Width = 100;
	Height = 30;

	Handle = CreateWindowEx(WS_EX_CLIENTEDGE, "EDIT", NULL,
		WS_CHILD | WS_VISIBLE | WS_DLGFRAME | ES_LEFT, 0, 0, 100, 30, parent, NULL, hInstance, NULL);

	SendMessage(Handle, WM_SETTEXT, 0, (LPARAM)(LPCTSTR) (string->GetString()));
}

EditControl::EditControl(HWND parent, HINSTANCE hInstance, unsigned long number)
{
	SP<StringStream> tempnum;

	tempnum = new StringStream(number);

	PosX = 0;
	PosY = 0;
	Width = 100;
	Height = 30;

	Handle = CreateWindowEx(WS_EX_CLIENTEDGE, "EDIT", NULL,
		WS_CHILD | WS_VISIBLE | WS_DLGFRAME | ES_LEFT | ES_NUMBER, 0, 0, 100, 30, parent, NULL, hInstance, NULL);

	SendMessage(Handle, WM_SETTEXT, 0, (LPARAM)(LPCTSTR) (tempnum->GetString()));
}

void EditControl::SetLimit(int limit)
{
	SendMessage(Handle, EM_SETLIMITTEXT, (WPARAM)limit, 0);
}

void EditControl::SetReadOnly(int flag)
{
	SendMessage(Handle, EM_SETREADONLY, (WPARAM)flag, 0);
}
