#include "Win32_WindowCodenet.h"
#include "Win32_StaticControl.h"
#include "Win32_PushButton.h"
#include "resource.h"
#include "stringops.h"
#include "debug.h"
#include "GlobalConfig.h"
#include <stdio.h>

static WindowCodenet *CodenetWin = 0;

static LRESULT CALLBACK HelpCallBack(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	if (CodenetWin) return CodenetWin->ProcessMessage(hwnd, msg, wParam, lParam);
	return DefWindowProc(hwnd, msg, wParam, lParam);
}

WindowCodenet::WindowCodenet(HINSTANCE hInstance)
{
	Handle = 0;
	Instance = hInstance;
	Text = 0;
}

WindowCodenet::~WindowCodenet(void)
{
	CloseControls();
}

void WindowCodenet::CloseControls(void)
{
	if (Text) delete Text;
	Text = 0;
}

void WindowCodenet::Open(HWND parent)
{
	WNDCLASSEX wc;
	long x, y, w, h;
	char clsname[]="Arc64_WindowCodenet";
	char wintitle[]="Codenet";

	if (CodenetWin) return;
	CodenetWin = this;

	wc.cbSize		= sizeof(WNDCLASSEX);
	wc.style		= 0;
	wc.lpfnWndProc	= HelpCallBack;
	wc.cbClsExtra	= 0;
	wc.cbWndExtra	= 0;
	wc.hInstance	= Instance;
	wc.hIcon		= LoadIcon(Instance, MAKEINTRESOURCE(IDI_ICON2));
	wc.hIconSm		= LoadIcon(Instance, MAKEINTRESOURCE(IDI_ICON1));
	wc.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = GetSysColorBrush(COLOR_3DFACE);
	wc.lpszMenuName	= NULL;
	wc.lpszClassName= clsname;

	if (!RegisterClassEx(&wc)) {
//		MessageBox(NULL, "Could not register window!", "Error!",
	//		MB_ICONEXCLAMATION | MB_OK);
		//return;
	}

	w = GetWidth();
	h = GetHeight();
	x = GetSystemMetrics(SM_CXSCREEN) - w;
	y = GetSystemMetrics(SM_CYSCREEN) - h;
	x >>= 1;
	y >>= 1;

	Handle = CreateWindowEx(0,
		clsname, wintitle,
		WS_OVERLAPPEDWINDOW & (~(WS_MINIMIZEBOX | WS_MAXIMIZEBOX | WS_SYSMENU)),
		x, y, w, h,
		parent, NULL, Instance, NULL);

	if (Handle == NULL) {
		CodenetWin = 0;
		MessageBox(NULL, "Could not create window!", "Error!",
			MB_ICONEXCLAMATION | MB_OK);
		return;
	}

	ShowWindow(Handle, SW_SHOW);
	UpdateWindow(Handle);
}

void WindowCodenet::Close(void)
{
	DestroyWindow(Handle);
}

LRESULT WindowCodenet::ProcessMessage(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	RECT clientrect;
	SP<StringStream> ip;

	switch (msg)
	{
	default:
		break;

	case WM_COMMAND:
	case WM_NOTIFY:
		return 0;

	case WM_KEYDOWN:
		switch (wParam)
		{
		default:
			break;
		case (VK_RETURN):
		case (VK_ESCAPE):
			CloseControls();
			DestroyWindow(hwnd);
			break;
		}
		break;

	case WM_CLOSE:
		CloseControls();
		DestroyWindow(hwnd);
		return 0;

	case WM_DESTROY:
		delete CodenetWin;
		CodenetWin = 0;
		break;

	case WM_CREATE:
		char tmp[1024];
		ip = Config->GetIP();
		sprintf(tmp, "Transferring file\n\n%s:%i", ip->GetString(), Config->GetNetPort());
		Text = new StaticControl(hwnd, Instance, tmp);
		return 0;

	case WM_ERASEBKGND:
		if (Text) Text->ExcludeFrom((HDC)wParam);
		break;

	case WM_PAINT:
		if (Text) Text->Update(hwnd);
		return 0;

	case WM_SIZE:
		GetClientRect(hwnd, &clientrect);

		if (Text) Text->SetPos(8, 8, clientrect.right-16, clientrect.bottom-16);
		return 0;

	case WM_GETMINMAXINFO:
		MINMAXINFO FAR *mmi;
		mmi = (MINMAXINFO FAR *) lParam;
		mmi->ptMinTrackSize.x = GetWidth();
		mmi->ptMinTrackSize.y = GetHeight();
		mmi->ptMaxTrackSize.x = mmi->ptMinTrackSize.x;
		mmi->ptMaxTrackSize.y = mmi->ptMinTrackSize.y;
		return 0;
	}
	return DefWindowProc(hwnd, msg, wParam, lParam);
}

int WindowCodenet::GetWidth(void)
{
	return 310+GetSystemMetrics(SM_CXFRAME)*2;
}

int WindowCodenet::GetHeight(void)
{
	return GetSystemMetrics(SM_CYFRAME)*2+GetSystemMetrics(SM_CYCAPTION)+80;
}
