#ifndef __WINDOWCONFIG_H__
#define __WINDOWCONFIG_H__

#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
#endif
#include <windows.h>

class WindowConfig
{
private:
	HINSTANCE Instance;

	class CbmWindow *MainWin;
	class StaticControl *Text;
	class CheckBoxControl *FileTrack18;
	class CheckBoxControl *DirTrack18;
	class StaticControl *InterleaveText;
	class ComboBox *Interleave;
	class StaticControl *StrategyText;
	class ComboBox *Strategy;

	class StaticControl *IPText;
	class EditControl *EditIP;
	class StaticControl *PortText;
	class EditControl *EditPort;

	class StaticControl *TextX64;
	class EditControl *EditX64;
	class PushButton *ButtonX64;

	class PushButton *ButtonOk;

	void CloseControls(void);

public:

	WindowConfig(HINSTANCE hInstance);
	~WindowConfig(void);

	LRESULT ProcessMessage(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

	void Open(HWND parent);
};

#endif
