#include <windows.h>
#include "Win32_WindowLogDir.h"
#include "Win32_StaticControl.h"
#include "Win32_PushButton.h"
#include "Win32_LogDisplay.h"
#include "resource.h"
#include "stringops.h"
#include "debug.h"
#include <shlobj.h>
#include <stdio.h>
#include "cbmlist.h"
#include "d64.h"
#include "atr.h"
#include "debug.h"
#include "stringops.h"
#include "StringStream.h"
#include "SmartPointer.h"
#include "FileImage.h"
#include "FileContainer.h"
#include "files.h"

extern void AddExtension(char *filename, char *extension);

int SaveRequesterLogDir(HWND handle, char *filename)
{
	OPENFILENAME ofn;
	BOOL ok;
	int i;

	for (i=0;i<sizeof(ofn);i++) ((unsigned char *)(&ofn))[i] = 0;

	ofn.lStructSize = sizeof(ofn);
	ofn.hwndOwner = 0;
	ofn.lpstrFile = filename;
	ofn.nMaxFile = _MAX_PATH;
	ofn.nFilterIndex = 2;
	ofn.lpstrFilter = "All files\0*\0Text files\0*.txt\0\0";
	ok = GetSaveFileName(&ofn);

	AddExtension(filename, ".txt");

	return ok;
}

int ReadFilesRequester(HWND owner, char *filename)
{
	IMalloc *imalloc = 0;
	char path[MAX_PATH];
	LPITEMIDLIST idlist;
	BROWSEINFO binfo;
	int ok;

	binfo.hwndOwner = owner;
	binfo.pidlRoot = 0;
	binfo.pszDisplayName = path;
	binfo.lpszTitle = 0;
	binfo.ulFlags = BIF_EDITBOX | BIF_VALIDATE;
	binfo.lpfn = 0;
	binfo.iImage = 0;

	ok = 0;
	idlist = SHBrowseForFolder(&binfo);
	if (idlist)
	{
		ok = (SHGetPathFromIDList(idlist, filename)) != 0;
		if (SUCCEEDED(SHGetMalloc(&imalloc)))
		{
			imalloc->Free(idlist);
			imalloc->Release();
		}
	}
	return ok;
}

int FileExistsMessageBox(HWND handle, const char *filename)
{
	DWORD fa;
	int ret;
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];
	char tmp[_MAX_PATH];
	char msg[_MAX_PATH+32];

	fa = GetFileAttributes(filename);
	if (fa == 0xFFFFFFFF) return 1;

	_splitpath( filename, drive, dir, fname, ext );
	_makepath( tmp, 0, 0, fname, ext );
	sprintf(msg, "%s\n\nFile exists, overwrite?", tmp);

	ret = MessageBox(handle, msg, "File exists", MB_YESNO | MB_ICONQUESTION);

	return (ret == IDYES);
}

// if path doesn't end with a backslash, add it
void AppendBackslash(char *path)
{
	int size;

	size = stringlen(path);
	if (size > 0) {
		if (path[size-1] != '\\') {
			path[size  ] = '\\';
			path[size+1] = 0;
		}
	}
}

// if path ends with a backslash, remove it
void RemoveBackslash(char *path)
{
	int size;

	size = stringlen(path);
	if (size > 0) {
		if (path[size-1] == '\\') {
			path[size-1] = 0;
		}
	}
}

// convert backslashes to slashes
void BackslashToSlash(char *path)
{
	int i;

	i = 0;
	while (path[i]) {
		if (path[i] == '\\') path[i] = '/';
		i++;
	}
}

// get directory name without path
void NameOnly(char *path, const char *src)
{
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];
	char tmp[_MAX_PATH];

	_splitpath( src, drive, dir, 0, 0 );
	_makepath( tmp, drive, dir, 0, 0 );
	RemoveBackslash(tmp);
	_splitpath( tmp, drive, dir, fname, ext );
	_makepath( path, 0, 0, fname, 0 );
}

// appends a directory name to a path
void AppendDirectory(char *xpath, const char *path, const char *name)
{
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];
	char tmppath[_MAX_PATH];

	_splitpath( path, drive, dir, fname, ext );
	_makepath( tmppath, 0, dir, fname, ext );

	_makepath( xpath, drive, tmppath, name, 0 );
}


void WindowLogDir::AddLog(const char *string)
{
	if (Log) Log->Add(string);
	sDPrintF("%s\n", string);
}

void WindowLogDir::MakeDirListing(const char *fullpath, const char *shortpath, FILE *f)
{
	WIN32_FIND_DATA fd;
	HANDLE ret;
	int ret2, i, type;
	FileImage *img;
	CbmList *list;
	char *ascii;

	char path[_MAX_PATH];
	char spath[_MAX_PATH];

	AppendDirectory(path, fullpath, "");
	AddLog(path);
	AppendDirectory(path, fullpath, "*");


	i = 0;
	ret = FindFirstFile(path, &fd);
	if (ret != INVALID_HANDLE_VALUE) {
		ret2 = true;
		while (ret2) {

			// if window closed, skip further scanning
			if (!LogWindowSync) return;

			if (fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
				if ((!stringcmp(fd.cFileName, ".")) && (!stringcmp(fd.cFileName, ".."))) {
				AppendDirectory(path, fullpath, fd.cFileName);
				AppendDirectory(spath, shortpath, fd.cFileName);

				MakeDirListing(path, spath, f);}
			} else {
				AppendDirectory(path, fullpath, fd.cFileName);
				AppendDirectory(spath, shortpath, fd.cFileName);

				img = CreateImage(path);
				if (img != 0) {
					list = img->GetDirectory();
					if (list) {
						BackslashToSlash(spath);
						ascii = list->GetASCII();
						fwrite((void*)"Image: ", 1, 7, f);
						fwrite((void*)spath, 1, stringlen(spath), f);
						fwrite((void*)"\n\n", 1, 2, f);
						fwrite((void*)ascii, 1, stringlen(ascii), f);
						fwrite((void*)"\n", 1, 1, f);
						list->Exit();
						delete[] list;
						delete[] ascii;
					}
					delete img;
				}
			}
			ret2 = FindNextFile(ret, &fd);
		}
	}
	FindClose(ret);
}

DWORD NetThreadCall(LPVOID arg)
{
	((WindowLogDir *)arg)->Call();
	return 0;
}

void WindowLogDir::Call(void)
{
	FILE *f;

	// wait until window is opened
	while (!LogWindowSync) { Sleep(100); }

	// flag: scanning thread running
	LogThreadSync = 1;

	f = fopen(DirLogFileName, "wb");
	if (f) {
		AddLog("Creating directory file:");
		MakeDirListing(DirLogPath, "", f);
		fclose(f);
		AddLog("Finished.");
	}

	// flag: scanning thread not running
	LogThreadSync = 0;
}

int WindowLogDir::MakeDirLog(HWND handle)
{
	DirLogPath = new char[_MAX_PATH];
	DirLogFileName = new char[_MAX_PATH];
	DirLogPath[0] = 0;
	DirLogFileName[0] = 0;

	if (ReadFilesRequester(handle, DirLogPath)) {

		AppendBackslash(DirLogPath);

		NameOnly(DirLogFileName, DirLogPath);

		if (SaveRequesterLogDir(handle, DirLogFileName)) {

			if (FileExistsMessageBox(handle, DirLogFileName)) {
				ThreadHandle = CreateThread(0, 0, (LPTHREAD_START_ROUTINE)NetThreadCall, (LPVOID)this, 0, &ThreadId);

				return 1;
			}
		}
	}
	return 0;
}

static WindowLogDir *LogDirWin = 0;

static LRESULT CALLBACK HelpCallBack(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	if (LogDirWin) return LogDirWin->ProcessMessage(hwnd, msg, wParam, lParam);
	return DefWindowProc(hwnd, msg, wParam, lParam);
}

WindowLogDir::WindowLogDir(HINSTANCE hInstance)
{
	Instance = hInstance;
	Text = 0;
	ButtonOk = 0;
	Log = 0;
	DirLogPath = 0;
	DirLogFileName = 0;
	LogWindowSync = 0;
	LogThreadSync = 0;
}

WindowLogDir::~WindowLogDir(void)
{
	CloseControls();
}

void WindowLogDir::CloseControls(void)
{
	LogWindowSync = 0;
	if (LogThreadSync) { Sleep(100); }

	if (Text) delete Text;
	if (ButtonOk) delete ButtonOk;
	if (Log) delete Log;
	Text = 0;
	ButtonOk = 0;
	Log = 0;

	if (DirLogPath) delete[] DirLogPath;
	if (DirLogFileName) delete[] DirLogFileName;
	DirLogPath = 0;
	DirLogFileName = 0;
}

void WindowLogDir::Open(HWND parent)
{
	WNDCLASSEX wc;
	HWND Handle;
	long x, y;
	char clsname[]="Arc64_WindowLogDir";
	char wintitle[]="Create Dirs";

	if (LogDirWin) return;
	LogDirWin = this;

	if (!MakeDirLog(parent)) {
		delete LogDirWin;
		LogDirWin = 0;
		return;
	}

	wc.cbSize		= sizeof(WNDCLASSEX);
	wc.style		= 0;
	wc.lpfnWndProc	= HelpCallBack;
	wc.cbClsExtra	= 0;
	wc.cbWndExtra	= 0;
	wc.hInstance	= Instance;
	wc.hIcon		= LoadIcon(Instance, MAKEINTRESOURCE(IDI_ICON2));
	wc.hIconSm		= LoadIcon(Instance, MAKEINTRESOURCE(IDI_ICON1));
	wc.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = GetSysColorBrush(COLOR_3DFACE);
	wc.lpszMenuName	= NULL;
	wc.lpszClassName= clsname;

	if (!RegisterClassEx(&wc)) {
//		MessageBox(NULL, "Could not register window!", "Error!",
	//		MB_ICONEXCLAMATION | MB_OK);
		//return;
	}

	x = 450;
	y = 500;

	Handle = CreateWindowEx(0,
		clsname, wintitle,
		WS_OVERLAPPEDWINDOW & (~(WS_MINIMIZEBOX | WS_MAXIMIZEBOX)),
		CW_USEDEFAULT, CW_USEDEFAULT, x, y,
		parent, NULL, Instance, NULL);

	if (Handle == NULL) {
		LogDirWin = 0;
		MessageBox(NULL, "Could not create window!", "Error!",
			MB_ICONEXCLAMATION | MB_OK);
		return;
	}

	ShowWindow(Handle, SW_SHOW);
	UpdateWindow(Handle);
}

LRESULT WindowLogDir::ProcessMessage(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	RECT clientrect;

	switch (msg)
	{
	default:
		break;

	case WM_COMMAND:
	case WM_NOTIFY:
		if ((ButtonOk) && (HIWORD(wParam) == BN_CLICKED)) {
			if (ButtonOk->IsControl((HWND)lParam)) {
				CloseControls();
				DestroyWindow(hwnd);
			}
		}
		return 0;

	case WM_KEYDOWN:
		switch (wParam)
		{
		default:
			break;
		case (VK_ESCAPE):
			CloseControls();
			DestroyWindow(hwnd);
			break;
		}
		break;

	case WM_CLOSE:
		CloseControls();
		DestroyWindow(hwnd);
		return 0;

	case WM_DESTROY:
		delete LogDirWin;
		LogDirWin = 0;
		break;

	case WM_CREATE:
		Text = new StaticControl(hwnd, Instance, "Log:");
//		ButtonOk = new PushButton(hwnd, Instance, "Ok");
		Log = new LogDisplay(hwnd, Instance);
		LogWindowSync = 1;
		return 0;

	case WM_ERASEBKGND:
		if (Text) Text->ExcludeFrom((HDC)wParam);
//		if (ButtonOk) ButtonOk->ExcludeFrom((HDC)wParam);
		if (Log) Log->ExcludeFrom((HDC)wParam);
		break;

	case WM_PAINT:
		if (Text) Text->Update(hwnd);
//		if (ButtonOk) ButtonOk->Update(hwnd);
		if (Log) Log->Update(hwnd);
		return 0;

	case WM_SIZE:
		GetClientRect(hwnd, &clientrect);

		if (Text) Text->SetPos(8, 8, clientrect.right-16, 16);
//		if (ButtonOk) ButtonOk->SetPos(8, clientrect.bottom-38, 70, 30);
		if (Log) Log->SetPos(8, 8+20, clientrect.right-16, clientrect.bottom-16-20);
		return 0;

	case WM_GETMINMAXINFO:
		MINMAXINFO FAR *mmi;
		mmi = (MINMAXINFO FAR *) lParam;
		mmi->ptMinTrackSize.x = 150+GetSystemMetrics(SM_CXFRAME)*2;
		mmi->ptMinTrackSize.y = GetSystemMetrics(SM_CYFRAME)*2+GetSystemMetrics(SM_CYCAPTION)+80;
		mmi->ptMaxTrackSize.x = mmi->ptMaxTrackSize.x;
		mmi->ptMaxTrackSize.y = mmi->ptMaxTrackSize.y;
		return 0;
	}
	return DefWindowProc(hwnd, msg, wParam, lParam);
}

