#ifndef __WINDOWLOGDIR_H__
#define __WINDOWLOGDIR_H__

#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
#endif
#include <windows.h>
#include <stdio.h>

class WindowLogDir
{
private:
	HINSTANCE Instance;

	class StaticControl *Text;
	class PushButton *ButtonOk;
	class LogDisplay *Log;

	char *DirLogPath;
	char *DirLogFileName;

	HANDLE ThreadHandle;
	DWORD ThreadId;
	int LogWindowSync;	// Flag: main window opened
	int LogThreadSync;	// Flag: d64 scanning thread running

	void CloseControls(void);

	void MakeDirListing(const char *fullpath, const char *shortpath, FILE *f);
	int MakeDirLog(HWND handle);
	void AddLog(const char *string);

public:

	WindowLogDir(HINSTANCE hInstance);
	~WindowLogDir(void);

	LRESULT ProcessMessage(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

	void Open(HWND parent);

	void Call(void);
};

#endif
