#include "Win32_WindowRename.h"
#include "Win32_StaticControl.h"
#include "Win32_PushButton.h"
#include "Win32_ComboBox.h"
#include "Win32_EditControl.h"
#include "Win32_CheckBoxControl.h"
#include "resource.h"
#include "stringops.h"
#include "window.h"
#include "debug.h"
#include "FileImage.h"
#include "DirEntry.h"

#define WRMODE_NULL		0
#define WRMODE_CBM		1
#define WRMODE_HEADER	2
#define WRMODE_ATR		3

static WindowRename *HelpWin = 0;

char *filetypelist[]=
{
	"DEL",
	"SEQ",
	"PRG",
	"USR",
	"REL",
	0
};

static LRESULT CALLBACK HelpCallBack(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	if (HelpWin) return HelpWin->ProcessMessage(hwnd, msg, wParam, lParam);
	return DefWindowProc(hwnd, msg, wParam, lParam);
}

WindowRename::WindowRename(HINSTANCE hInstance, CbmWindow *mainwin, unsigned long index, SP<FileImage> img)
{
	Instance = hInstance;
	Mode = WRMODE_NULL;

	MainWin = mainwin;
	Index = index;
	Image = img;
	EntryD64 = 0;
	TempEntryD64 = 0;
	EntryATR = 0;
	TempEntryATR = 0;
	EntryHeader = 0;
	TempEntryHeader = 0;
	String = 0;
	Id = 0;
	Type = 0;

	switch (Image->GetImageSystem())
	{
	default:
		break;
	case (IMAGESYSTEM_CBM):
		if (index > 0) {
			EntryD64 = new DirEntryD64;
			EntryD64->Entry = Image->GetDirEntry(index);
			TempEntryD64 = EntryD64->DeepCopy();
			String = TempEntryD64->GetFileNameASCII();
			Mode = WRMODE_CBM;
		} else {
			EntryHeader = new DirEntryHeader;
			EntryHeader->Entry = Image->GetHeader();
			TempEntryHeader = EntryHeader->DeepCopy();
			String = TempEntryHeader->GetHeaderASCII();
			Id = TempEntryHeader->GetIdASCII();
			Mode = WRMODE_HEADER;
		}
		break;
	case (IMAGESYSTEM_ATR):
		if (index > 0) {
			EntryATR = new DirEntryATR;
			EntryATR->Entry = Image->GetDirEntry(index);
			TempEntryATR = EntryATR->DeepCopy();
			String = TempEntryATR->GetFileNameASCII();
			Mode = WRMODE_ATR;
		}
		break;
	}

	Text = 0;
	FileNameEdit = 0;
	IdEdit = 0;
	FileType = 0;
	BlockCountEdit = 0;
	SelProtection = 0;
	SelClosed = 0;
	SelLocked = 0;
	SelInUse = 0;
	SelDOS2 = 0;
	SelOpened = 0;
	SelDeleted = 0;
	ButtonOk = 0;
	ButtonCancel = 0;
}

WindowRename::~WindowRename(void)
{
	CloseControls();

	String = 0;
	Id = 0;

	if (EntryD64) delete[] EntryD64;
	if (TempEntryD64) {
		TempEntryD64->Exit();
		delete[] TempEntryD64;
	}
	if (EntryATR) delete[] EntryATR;
	if (TempEntryATR) {
		TempEntryATR->Exit();
		delete[] TempEntryATR;
	}
	if (EntryHeader) delete[] EntryHeader;
	if (TempEntryHeader) {
		TempEntryHeader->Exit();
		delete[] TempEntryHeader;
	}
}

void WindowRename::CloseControls(void)
{
	if (Text) delete Text;
	if (FileNameEdit) delete FileNameEdit;
	if (IdEdit) delete IdEdit;
	if (FileType) delete FileType;
	if (BlockCountEdit) delete BlockCountEdit;
	if (SelProtection) delete SelProtection;
	if (SelClosed) delete SelClosed;
	if (SelLocked) delete SelLocked;
	if (SelInUse) delete SelInUse;
	if (SelDOS2) delete SelDOS2;
	if (SelOpened) delete SelOpened;
	if (SelDeleted) delete SelDeleted;
	if (ButtonOk) delete ButtonOk;
	if (ButtonCancel) delete ButtonCancel;
	Text = 0;
	FileNameEdit = 0;
	IdEdit = 0;
	FileType = 0;
	BlockCountEdit = 0;
	SelProtection = 0;
	SelClosed = 0;
	SelLocked = 0;
	SelInUse = 0;
	SelDOS2 = 0;
	SelOpened = 0;
	SelDeleted = 0;
	ButtonOk = 0;
	ButtonCancel = 0;
}

void WindowRename::Open(HWND parent)
{
	WNDCLASSEX wc;
	HWND Handle;
	long x, y;
	char clsname[]="Arc64_WindowRename";
	char *wintitle;

	if (HelpWin) return;
	HelpWin = this;

	wc.cbSize		= sizeof(WNDCLASSEX);
	wc.style		= 0;
	wc.lpfnWndProc	= HelpCallBack;
	wc.cbClsExtra	= 0;
	wc.cbWndExtra	= 0;
	wc.hInstance	= Instance;
	wc.hIcon		= LoadIcon(Instance, MAKEINTRESOURCE(IDI_ICON2));
	wc.hIconSm		= LoadIcon(Instance, MAKEINTRESOURCE(IDI_ICON1));
	wc.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = GetSysColorBrush(COLOR_3DFACE);
	wc.lpszMenuName	= NULL;
	wc.lpszClassName= clsname;

	if (!RegisterClassEx(&wc)) {
//		MessageBox(NULL, "Could not register window!", "Error!",
	//		MB_ICONEXCLAMATION | MB_OK);
		//return;
	}

	if (Mode == WRMODE_HEADER) wintitle = "Header";
	else wintitle = "Rename";

	x = 300;
	y = 300;

	Handle = CreateWindowEx(0,
		clsname, wintitle,
		WS_OVERLAPPEDWINDOW & (~(WS_MINIMIZEBOX | WS_MAXIMIZEBOX)),
		CW_USEDEFAULT, CW_USEDEFAULT, x, y,
		parent, NULL, Instance, NULL);

	if (Handle == NULL) {
		HelpWin = 0;
		MessageBox(NULL, "Could not create window!", "Error!",
			MB_ICONEXCLAMATION | MB_OK);
		return;
	}

	ShowWindow(Handle, SW_SHOW);
	UpdateWindow(Handle);
}

LRESULT WindowRename::ProcessMessage(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	RECT clientrect;
	int close, update, sel, y;
	SP<StringStream> tempstr;

	switch (msg)
	{
	default:
		break;

	case WM_COMMAND:
	case WM_NOTIFY:
		close = 0;
		update = 0;

		if (FileNameEdit) {
			if (FileNameEdit->IsControl((HWND)lParam)) {
				if (HIWORD(wParam) == EN_CHANGE) {
					tempstr = FileNameEdit->GetText();
					switch (Mode)
					{
					default:
						break;
					case (WRMODE_CBM):
						EntryD64->SetFileNameASCII(tempstr);
						break;
					case (WRMODE_ATR):
						EntryATR->SetFileNameASCII(tempstr);
						break;
					case (WRMODE_HEADER):
						EntryHeader->SetHeaderASCII(tempstr);
						break;
					}
					update = 1;
				}
			}
		}

		if (IdEdit) {
			if (IdEdit->IsControl((HWND)lParam)) {
				if (HIWORD(wParam) == EN_CHANGE) {
					tempstr = IdEdit->GetText();
					EntryHeader->SetIdASCII(tempstr);
					update = 1;
				}
			}
		}

		if (BlockCountEdit) {
			if (BlockCountEdit->IsControl((HWND)lParam)) {
				if (HIWORD(wParam) == EN_CHANGE) {
					tempstr = BlockCountEdit->GetText();
					sel = tempstr->ParseInteger();
					if (sel > 65535) sel = 65535;
					switch (Mode)
					{
					default:
						break;
					case (WRMODE_CBM):
						EntryD64->SetBlockCount(sel);
						break;
					case (WRMODE_ATR):
						EntryATR->SetBlockCount(sel);
						break;
					case (WRMODE_HEADER):
						EntryHeader->SetBlockCount(sel);
						break;
					}
					update = 1;
				}
			}
		}

		if (FileType) {
			if (HIWORD(wParam) == CBN_SELCHANGE) {
				EntryD64->SetFileType(FileType->GetSelection());
				update = 1;
			}
		}

		if ((SelProtection) && (HIWORD(wParam) == BN_CLICKED)) {
			if (SelProtection->IsControl((HWND)lParam)) {
				sel = !SelProtection->GetCheck();
				SelProtection->SetCheck(sel);
				if (Mode == WRMODE_CBM) {
					EntryD64->SetProtection(sel != 0);
				} else {
					EntryHeader->SetProtection(sel != 0);
				}
				update = 1;
			}
		}

		if ((SelClosed) && (HIWORD(wParam) == BN_CLICKED)) {
			if (SelClosed->IsControl((HWND)lParam)) {
				sel = !SelClosed->GetCheck();
				SelClosed->SetCheck(sel);
				EntryD64->SetClosed(sel != 0);
				update = 1;
			}
		}

		if ((SelLocked) && (HIWORD(wParam) == BN_CLICKED)) {
			if (SelLocked->IsControl((HWND)lParam)) {
				sel = !SelLocked->GetCheck();
				SelLocked->SetCheck(sel);
				EntryATR->SetLocked(sel != 0);
				update = 1;
			}
		}

		if ((SelInUse) && (HIWORD(wParam) == BN_CLICKED)) {
			if (SelInUse->IsControl((HWND)lParam)) {
				sel = !SelInUse->GetCheck();
				SelInUse->SetCheck(sel);
				EntryATR->SetInUse(sel != 0);
				update = 1;
			}
		}

		if ((SelDOS2) && (HIWORD(wParam) == BN_CLICKED)) {
			if (SelDOS2->IsControl((HWND)lParam)) {
				sel = !SelDOS2->GetCheck();
				SelDOS2->SetCheck(sel);
				EntryATR->SetDOS2(sel != 0);
				update = 1;
			}
		}

		if ((SelOpened) && (HIWORD(wParam) == BN_CLICKED)) {
			if (SelOpened->IsControl((HWND)lParam)) {
				sel = !SelOpened->GetCheck();
				SelOpened->SetCheck(sel);
				EntryATR->SetOpened(sel != 0);
				update = 1;
			}
		}

		if ((SelDeleted) && (HIWORD(wParam) == BN_CLICKED)) {
			if (SelDeleted->IsControl((HWND)lParam)) {
				sel = !SelDeleted->GetCheck();
				SelDeleted->SetCheck(sel);
				EntryATR->SetDeleted(sel != 0);
				update = 1;
			}
		}

		if ((ButtonOk) && (HIWORD(wParam) == BN_CLICKED)) {
			if (ButtonOk->IsControl((HWND)lParam)) {
				tempstr = FileNameEdit->GetText();
				switch (Mode)
				{
				default:
					break;
				case (WRMODE_CBM):
					EntryD64->SetFileNameASCII(tempstr);
					break;
				case (WRMODE_ATR):
					EntryATR->SetFileNameASCII(tempstr);
					break;
				case (WRMODE_HEADER):
					EntryHeader->SetHeaderASCII(tempstr);
					tempstr = IdEdit->GetText();
					EntryHeader->SetIdASCII(tempstr);
					break;
				}
				update = 1;
				close = 1;
			}
		}

		if ((ButtonCancel) && (HIWORD(wParam) == BN_CLICKED)) {
			if (ButtonCancel->IsControl((HWND)lParam)) {
				UpdateImage();
				update = 1;
				close = 1;
			}
		}

		if (update) MainWin->RefreshImageDisplay();

		if (close) {
			CloseControls();
			DestroyWindow(hwnd);
		}
		return 0;

	case WM_KEYDOWN:
		switch (wParam)
		{
		default:
			break;
		case (VK_RETURN):
			UpdateImage();
			MainWin->RefreshImageDisplay();
			CloseControls();
			DestroyWindow(hwnd);
			break;
		case (VK_ESCAPE):
			CloseControls();
			DestroyWindow(hwnd);
			break;
		}
		break;

	case WM_CLOSE:
		if (EntryD64 && TempEntryD64) EntryD64->SetEntry(TempEntryD64);
		if (EntryATR && TempEntryATR) EntryATR->SetEntry(TempEntryATR);
		if (EntryHeader && TempEntryHeader) EntryHeader->SetEntry(TempEntryHeader);
		MainWin->RefreshImageDisplay();
		CloseControls();
		DestroyWindow(hwnd);
		return 0;

	case WM_DESTROY:
		delete HelpWin;
		HelpWin = 0;
		break;

	case WM_CREATE:
		Text = new StaticControl(hwnd, Instance, "Filename:");
		FileNameEdit = new EditControl(hwnd, Instance, String);
		FileNameEdit->SetLimit(16);

		switch (Mode)
		{
		default:
			break;
		case (WRMODE_HEADER):
			IdEdit = new EditControl(hwnd, Instance, Id);
			IdEdit->SetLimit(5);
			SelProtection = new CheckBoxControl(hwnd, Instance, "Protected");
			SelProtection->SetCheck(EntryHeader->GetProtection());
			BlockCountEdit = new EditControl(hwnd, Instance, EntryHeader->GetBlockCount());
			BlockCountEdit->SetLimit(5);
			break;
		case (WRMODE_CBM):
			FileType = new ComboBox(hwnd, Instance, filetypelist, EntryD64->GetFileType());
			SelProtection = new CheckBoxControl(hwnd, Instance, "Protected");
			SelProtection->SetCheck(EntryD64->GetProtection());
			SelClosed = new CheckBoxControl(hwnd, Instance, "Closed");
			SelClosed->SetCheck(EntryD64->GetClosed());
			BlockCountEdit = new EditControl(hwnd, Instance, EntryD64->GetBlockCount());
			BlockCountEdit->SetLimit(5);
			break;
		case (WRMODE_ATR):
			SelLocked = new CheckBoxControl(hwnd, Instance, "Locked");
			SelLocked->SetCheck(TempEntryATR->GetLocked());
			SelInUse = new CheckBoxControl(hwnd, Instance, "In use");
			SelInUse->SetCheck(TempEntryATR->GetInUse());
			SelDOS2 = new CheckBoxControl(hwnd, Instance, "DOS 2 file");
			SelDOS2->SetCheck(TempEntryATR->GetDOS2());
			SelOpened = new CheckBoxControl(hwnd, Instance, "Opened");
			SelOpened->SetCheck(TempEntryATR->GetOpened());
			SelDeleted = new CheckBoxControl(hwnd, Instance, "Deleted");
			SelDeleted->SetCheck(TempEntryATR->GetDeleted());
			BlockCountEdit = new EditControl(hwnd, Instance, EntryATR->GetBlockCount());
			BlockCountEdit->SetLimit(5);
			break;
		}
		ButtonOk = new PushButton(hwnd, Instance, "Ok");
		ButtonCancel = new PushButton(hwnd, Instance, "Cancel");
		return 0;

	case WM_ERASEBKGND:
		if (Text) Text->ExcludeFrom((HDC)wParam);
		if (FileNameEdit) FileNameEdit->ExcludeFrom((HDC)wParam);
		if (IdEdit) IdEdit->ExcludeFrom((HDC)wParam);
		if (BlockCountEdit) BlockCountEdit->ExcludeFrom((HDC)wParam);
//		if (FileType) FileType->ExcludeFrom((HDC)wParam);
		if (SelProtection) SelProtection->ExcludeFrom((HDC)wParam);
		if (SelClosed) SelClosed->ExcludeFrom((HDC)wParam);
		if (SelLocked) SelLocked->ExcludeFrom((HDC)wParam);
		if (SelInUse) SelInUse->ExcludeFrom((HDC)wParam);
		if (SelDOS2) SelDOS2->ExcludeFrom((HDC)wParam);
		if (SelOpened) SelOpened->ExcludeFrom((HDC)wParam);
		if (SelDeleted) SelDeleted->ExcludeFrom((HDC)wParam);
		if (ButtonOk) ButtonOk->ExcludeFrom((HDC)wParam);
		if (ButtonCancel) ButtonCancel->ExcludeFrom((HDC)wParam);
		break;

	case WM_PAINT:
		if (Text) Text->Update(hwnd);
		if (FileNameEdit) FileNameEdit->Update(hwnd);
		if (IdEdit) IdEdit->Update(hwnd);
		if (BlockCountEdit) BlockCountEdit->Update(hwnd);
		if (FileType) FileType->Update(hwnd);
		if (SelProtection) SelProtection->Update(hwnd);
		if (SelClosed) SelClosed->Update(hwnd);
		if (SelLocked) SelLocked->Update(hwnd);
		if (SelInUse) SelInUse->Update(hwnd);
		if (SelDOS2) SelDOS2->Update(hwnd);
		if (SelOpened) SelOpened->Update(hwnd);
		if (SelDeleted) SelDeleted->Update(hwnd);
		if (ButtonOk) ButtonOk->Update(hwnd);
		if (ButtonCancel) ButtonCancel->Update(hwnd);
		return 0;

	case WM_SIZE:
		GetClientRect(hwnd, &clientrect);

		if (Text) Text->SetPos(8, 8, clientrect.right-16, 20);
		if (FileNameEdit) FileNameEdit->SetPos(8, 32, 210, 30);

		y = 70;
		if (BlockCountEdit) BlockCountEdit->SetPos(220, y, 80, 30);
		switch (Mode)
		{
		default:
			break;
		case (WRMODE_HEADER):
		case (WRMODE_CBM):
			if (IdEdit) IdEdit->SetPos(220, 32, 80, 30);
			if (FileType) FileType->SetPos(220, 35, 80, 200);
			if (SelProtection) SelProtection->SetPos(8, y, 100, 30);	y += 28;
			if (SelClosed) SelClosed->SetPos(8, y, 100, 30);
			break;
		case (WRMODE_ATR):
			if (SelLocked) SelLocked->SetPos(8, y, 100, 30);			y += 28;
			if (SelInUse) SelInUse->SetPos(8, y, 100, 30);				y += 28;
			if (SelDOS2) SelDOS2->SetPos(8, y, 100, 30);				y += 28;
			if (SelOpened) SelOpened->SetPos(8, y, 100, 30);			y += 28;
			if (SelDeleted) SelDeleted->SetPos(8, y, 100, 30);
			break;
		}
		if (ButtonOk) ButtonOk->SetPos(8, clientrect.bottom-38, 70, 30);
		if (ButtonCancel) ButtonCancel->SetPos(90, clientrect.bottom-38, 70, 30);
		return 0;

	case WM_GETMINMAXINFO:
		MINMAXINFO FAR *mmi;
		mmi = (MINMAXINFO FAR *) lParam;
		mmi->ptMinTrackSize.x = 310+GetSystemMetrics(SM_CXFRAME)*2;
		mmi->ptMinTrackSize.y = GetSystemMetrics(SM_CYFRAME)*2+GetSystemMetrics(SM_CYCAPTION)+146;
		mmi->ptMaxTrackSize.x = mmi->ptMinTrackSize.x;
		mmi->ptMaxTrackSize.y = mmi->ptMinTrackSize.y;
		switch (Mode)
		{
		default:
			break;
		case (WRMODE_CBM):
			mmi->ptMinTrackSize.y += 28;
			break;
		case (WRMODE_ATR):
			mmi->ptMinTrackSize.y += 84+28;
			break;
		}
		return 0;
	}
	return DefWindowProc(hwnd, msg, wParam, lParam);
}

void WindowRename::UpdateImage(void)
{
	if (EntryD64 && TempEntryD64) EntryD64->SetEntry(TempEntryD64);
	if (EntryATR && TempEntryATR) EntryATR->SetEntry(TempEntryATR);
	if (EntryHeader && TempEntryHeader) EntryHeader->SetEntry(TempEntryHeader);
}
