#ifndef ___C64FILE_H___
#define ___C64FILE_H___

#include "SmartPointer.h"
#include "StringStream.h"
#include "ByteBuffer.h"

#define FILEFORMAT_CBM 1
#define FILEFORMAT_ATARI 2

class C64File
{
private:
	SP<ByteBuffer> Name;
	unsigned char *Data;
	unsigned long Size;
	unsigned char Type;		/* in raw D64 format (0x82 for PRG) */
	unsigned long Format;

public:
	C64File();
	C64File(SP<ByteBuffer> name, unsigned char *data, unsigned long size, unsigned char type, unsigned char format);
	~C64File();

	SP<ByteBuffer> GetName();
	unsigned char *GetData();
	unsigned long GetSize();
	unsigned char GetType();

	SP<StringStream> Save(SP<StringStream> cpath);
};

SP<C64File> LoadFile(SP<StringStream> path);

#endif
