#include "cbmlist.h"
#include "stringops.h"
#include "debug.h"
#include <stdio.h>

static unsigned char prechratari[1024] =
{
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18, 0x00, 
        0x00, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xFF, 0x66, 0x66, 0xFF, 0x66, 0x00, 
        0x18, 0x3E, 0x60, 0x3C, 0x06, 0x7C, 0x18, 0x00, 0x00, 0x66, 0x6C, 0x18, 0x30, 0x66, 0x46, 0x00, 
        0x1C, 0x36, 0x1C, 0x38, 0x6F, 0x66, 0x3B, 0x00, 0x00, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x0E, 0x1C, 0x18, 0x18, 0x1C, 0x0E, 0x00, 0x00, 0x70, 0x38, 0x18, 0x18, 0x38, 0x70, 0x00, 
        0x00, 0x66, 0x3C, 0xFF, 0x3C, 0x66, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7E, 0x18, 0x18, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x06, 0x0C, 0x18, 0x30, 0x60, 0x40, 0x00, 
        0x00, 0x3C, 0x66, 0x6E, 0x76, 0x66, 0x3C, 0x00, 0x00, 0x18, 0x38, 0x18, 0x18, 0x18, 0x7E, 0x00, 
        0x00, 0x3C, 0x66, 0x0C, 0x18, 0x30, 0x7E, 0x00, 0x00, 0x7E, 0x0C, 0x18, 0x0C, 0x66, 0x3C, 0x00, 
        0x00, 0x0C, 0x1C, 0x3C, 0x6C, 0x7E, 0x0C, 0x00, 0x00, 0x7E, 0x60, 0x7C, 0x06, 0x66, 0x3C, 0x00, 
        0x00, 0x3C, 0x60, 0x7C, 0x66, 0x66, 0x3C, 0x00, 0x00, 0x7E, 0x06, 0x0C, 0x18, 0x30, 0x30, 0x00, 
        0x00, 0x3C, 0x66, 0x3C, 0x66, 0x66, 0x3C, 0x00, 0x00, 0x3C, 0x66, 0x3E, 0x06, 0x0C, 0x38, 0x00, 
        0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x30, 
        0x06, 0x0C, 0x18, 0x30, 0x18, 0x0C, 0x06, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x7E, 0x00, 0x00, 
        0x60, 0x30, 0x18, 0x0C, 0x18, 0x30, 0x60, 0x00, 0x00, 0x3C, 0x66, 0x0C, 0x18, 0x00, 0x18, 0x00, 
        0x00, 0x3C, 0x66, 0x6E, 0x6E, 0x60, 0x3E, 0x00, 0x00, 0x18, 0x3C, 0x66, 0x66, 0x7E, 0x66, 0x00, 
        0x00, 0x7C, 0x66, 0x7C, 0x66, 0x66, 0x7C, 0x00, 0x00, 0x3C, 0x66, 0x60, 0x60, 0x66, 0x3C, 0x00, 
        0x00, 0x78, 0x6C, 0x66, 0x66, 0x6C, 0x78, 0x00, 0x00, 0x7E, 0x60, 0x7C, 0x60, 0x60, 0x7E, 0x00, 
        0x00, 0x7E, 0x60, 0x7C, 0x60, 0x60, 0x60, 0x00, 0x00, 0x3E, 0x60, 0x60, 0x6E, 0x66, 0x3E, 0x00, 
        0x00, 0x66, 0x66, 0x7E, 0x66, 0x66, 0x66, 0x00, 0x00, 0x7E, 0x18, 0x18, 0x18, 0x18, 0x7E, 0x00, 
        0x00, 0x06, 0x06, 0x06, 0x06, 0x66, 0x3C, 0x00, 0x00, 0x66, 0x6C, 0x78, 0x78, 0x6C, 0x66, 0x00, 
        0x00, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7E, 0x00, 0x00, 0x63, 0x77, 0x7F, 0x6B, 0x63, 0x63, 0x00, 
        0x00, 0x66, 0x76, 0x7E, 0x7E, 0x6E, 0x66, 0x00, 0x00, 0x3C, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x00, 
        0x00, 0x7C, 0x66, 0x66, 0x7C, 0x60, 0x60, 0x00, 0x00, 0x3C, 0x66, 0x66, 0x66, 0x6C, 0x36, 0x00, 
        0x00, 0x7C, 0x66, 0x66, 0x7C, 0x6C, 0x66, 0x00, 0x00, 0x3C, 0x60, 0x3C, 0x06, 0x06, 0x3C, 0x00, 
        0x00, 0x7E, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7E, 0x00, 
        0x00, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x18, 0x00, 0x00, 0x63, 0x63, 0x6B, 0x7F, 0x77, 0x63, 0x00, 
        0x00, 0x66, 0x66, 0x3C, 0x3C, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x3C, 0x18, 0x18, 0x18, 0x00, 
        0x00, 0x7E, 0x0C, 0x18, 0x30, 0x60, 0x7E, 0x00, 0x00, 0x1E, 0x18, 0x18, 0x18, 0x18, 0x1E, 0x00, 
        0x00, 0x40, 0x60, 0x30, 0x18, 0x0C, 0x06, 0x00, 0x00, 0x78, 0x18, 0x18, 0x18, 0x18, 0x78, 0x00, 
        0x00, 0x08, 0x1C, 0x36, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 
        0x00, 0x36, 0x7F, 0x7F, 0x3E, 0x1C, 0x08, 0x00, 0x18, 0x18, 0x18, 0x1F, 0x1F, 0x18, 0x18, 0x18, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x18, 0x18, 0x18, 0xF8, 0xF8, 0x00, 0x00, 0x00, 
        0x18, 0x18, 0x18, 0xF8, 0xF8, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0xF8, 0xF8, 0x18, 0x18, 0x18, 
        0x03, 0x07, 0x0E, 0x1C, 0x38, 0x70, 0xE0, 0xC0, 0xC0, 0xE0, 0x70, 0x38, 0x1C, 0x0E, 0x07, 0x03, 
        0x01, 0x03, 0x07, 0x0F, 0x1F, 0x3F, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x80, 0xC0, 0xE0, 0xF0, 0xF8, 0xFC, 0xFE, 0xFF, 0x0F, 0x0F, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 
        0xF0, 0xF0, 0xF0, 0xF0, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xF0, 0xF0, 0xF0, 
        0x00, 0x1C, 0x1C, 0x77, 0x77, 0x08, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x1F, 0x18, 0x18, 0x18, 
        0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0xFF, 0xFF, 0x18, 0x18, 0x18, 
        0x00, 0x00, 0x3C, 0x7E, 0x7E, 0x7E, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 
        0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x18, 0x18, 0x18, 
        0x18, 0x18, 0x18, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 
        0x18, 0x18, 0x18, 0x1F, 0x1F, 0x00, 0x00, 0x00, 0x78, 0x60, 0x78, 0x60, 0x7E, 0x18, 0x1E, 0x00, 
        0x00, 0x18, 0x3C, 0x7E, 0x18, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x18, 0x7E, 0x3C, 0x18, 0x00, 
        0x00, 0x18, 0x30, 0x7E, 0x30, 0x18, 0x00, 0x00, 0x00, 0x18, 0x0C, 0x7E, 0x0C, 0x18, 0x00, 0x00, 
        0x00, 0x18, 0x3C, 0x7E, 0x7E, 0x3C, 0x18, 0x00, 0x00, 0x00, 0x3C, 0x06, 0x3E, 0x66, 0x3E, 0x00, 
        0x00, 0x60, 0x60, 0x7C, 0x66, 0x66, 0x7C, 0x00, 0x00, 0x00, 0x3C, 0x60, 0x60, 0x60, 0x3C, 0x00, 
        0x00, 0x06, 0x06, 0x3E, 0x66, 0x66, 0x3E, 0x00, 0x00, 0x00, 0x3C, 0x66, 0x7E, 0x60, 0x3C, 0x00, 
        0x00, 0x0E, 0x18, 0x3E, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x3E, 0x66, 0x66, 0x3E, 0x06, 0x7C, 
        0x00, 0x60, 0x60, 0x7C, 0x66, 0x66, 0x66, 0x00, 0x00, 0x18, 0x00, 0x38, 0x18, 0x18, 0x3C, 0x00, 
        0x00, 0x06, 0x00, 0x06, 0x06, 0x06, 0x06, 0x3C, 0x00, 0x60, 0x60, 0x6C, 0x78, 0x6C, 0x66, 0x00, 
        0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x3C, 0x00, 0x00, 0x00, 0x66, 0x7F, 0x7F, 0x6B, 0x63, 0x00, 
        0x00, 0x00, 0x7C, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x3C, 0x66, 0x66, 0x66, 0x3C, 0x00, 
        0x00, 0x00, 0x7C, 0x66, 0x66, 0x7C, 0x60, 0x60, 0x00, 0x00, 0x3E, 0x66, 0x66, 0x3E, 0x06, 0x06, 
        0x00, 0x00, 0x7C, 0x66, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x3E, 0x60, 0x3C, 0x06, 0x7C, 0x00, 
        0x00, 0x18, 0x7E, 0x18, 0x18, 0x18, 0x0E, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3E, 0x00, 
        0x00, 0x00, 0x66, 0x66, 0x66, 0x3C, 0x18, 0x00, 0x00, 0x00, 0x63, 0x6B, 0x7F, 0x3E, 0x36, 0x00, 
        0x00, 0x00, 0x66, 0x3C, 0x18, 0x3C, 0x66, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x3E, 0x0C, 0x78, 
        0x00, 0x00, 0x7E, 0x0C, 0x18, 0x30, 0x7E, 0x00, 0x00, 0x18, 0x3C, 0x7E, 0x7E, 0x18, 0x3C, 0x00, 
        0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x7E, 0x78, 0x7C, 0x6E, 0x66, 0x06, 0x00, 
        0x08, 0x18, 0x38, 0x78, 0x38, 0x18, 0x08, 0x00, 0x10, 0x18, 0x1C, 0x1E, 0x1C, 0x18, 0x10, 0x00
};

static unsigned char prechr[1024] =
{
        0x3C, 0x66, 0x6E, 0x6E, 0x60, 0x62, 0x3C, 0x00, 0x18, 0x3C, 0x66, 0x7E, 0x66, 0x66, 0x66, 0x00, 
        0x7C, 0x66, 0x66, 0x7C, 0x66, 0x66, 0x7C, 0x00, 0x3C, 0x66, 0x60, 0x60, 0x60, 0x66, 0x3C, 0x00, 
        0x78, 0x6C, 0x66, 0x66, 0x66, 0x6C, 0x78, 0x00, 0x7E, 0x60, 0x60, 0x78, 0x60, 0x60, 0x7E, 0x00, 
        0x7E, 0x60, 0x60, 0x78, 0x60, 0x60, 0x60, 0x00, 0x3C, 0x66, 0x60, 0x6E, 0x66, 0x66, 0x3C, 0x00, 
        0x66, 0x66, 0x66, 0x7E, 0x66, 0x66, 0x66, 0x00, 0x3C, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3C, 0x00, 
        0x1E, 0x0C, 0x0C, 0x0C, 0x0C, 0x6C, 0x38, 0x00, 0x66, 0x6C, 0x78, 0x70, 0x78, 0x6C, 0x66, 0x00, 
        0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7E, 0x00, 0x63, 0x77, 0x7F, 0x6B, 0x63, 0x63, 0x63, 0x00, 
        0x66, 0x76, 0x7E, 0x7E, 0x6E, 0x66, 0x66, 0x00, 0x3C, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x00, 
        0x7C, 0x66, 0x66, 0x7C, 0x60, 0x60, 0x60, 0x00, 0x3C, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x0E, 0x00, 
        0x7C, 0x66, 0x66, 0x7C, 0x78, 0x6C, 0x66, 0x00, 0x3C, 0x66, 0x60, 0x3C, 0x06, 0x66, 0x3C, 0x00, 
        0x7E, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x00, 
        0x66, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x18, 0x00, 0x63, 0x63, 0x63, 0x6B, 0x7F, 0x77, 0x63, 0x00, 
        0x66, 0x66, 0x3C, 0x18, 0x3C, 0x66, 0x66, 0x00, 0x66, 0x66, 0x66, 0x3C, 0x18, 0x18, 0x18, 0x00, 
        0x7E, 0x06, 0x0C, 0x18, 0x30, 0x60, 0x7E, 0x00, 0x3C, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3C, 0x00, 
        0x0C, 0x12, 0x30, 0x7C, 0x30, 0x62, 0xFC, 0x00, 0x3C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x3C, 0x00, 
        0x00, 0x18, 0x3C, 0x7E, 0x18, 0x18, 0x18, 0x18, 0x00, 0x10, 0x30, 0x7F, 0x7F, 0x30, 0x10, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x18, 0x00, 
        0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0xFF, 0x66, 0xFF, 0x66, 0x66, 0x00, 
        0x18, 0x3E, 0x60, 0x3C, 0x06, 0x7C, 0x18, 0x00, 0x62, 0x66, 0x0C, 0x18, 0x30, 0x66, 0x46, 0x00, 
        0x3C, 0x66, 0x3C, 0x38, 0x67, 0x66, 0x3F, 0x00, 0x06, 0x0C, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x0C, 0x18, 0x30, 0x30, 0x30, 0x18, 0x0C, 0x00, 0x30, 0x18, 0x0C, 0x0C, 0x0C, 0x18, 0x30, 0x00, 
        0x00, 0x66, 0x3C, 0xFF, 0x3C, 0x66, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7E, 0x18, 0x18, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x03, 0x06, 0x0C, 0x18, 0x30, 0x60, 0x00, 
        0x3C, 0x66, 0x6E, 0x76, 0x66, 0x66, 0x3C, 0x00, 0x18, 0x18, 0x38, 0x18, 0x18, 0x18, 0x7E, 0x00, 
        0x3C, 0x66, 0x06, 0x0C, 0x30, 0x60, 0x7E, 0x00, 0x3C, 0x66, 0x06, 0x1C, 0x06, 0x66, 0x3C, 0x00, 
        0x06, 0x0E, 0x1E, 0x66, 0x7F, 0x06, 0x06, 0x00, 0x7E, 0x60, 0x7C, 0x06, 0x06, 0x66, 0x3C, 0x00, 
        0x3C, 0x66, 0x60, 0x7C, 0x66, 0x66, 0x3C, 0x00, 0x7E, 0x66, 0x0C, 0x18, 0x18, 0x18, 0x18, 0x00, 
        0x3C, 0x66, 0x66, 0x3C, 0x66, 0x66, 0x3C, 0x00, 0x3C, 0x66, 0x66, 0x3E, 0x06, 0x66, 0x3C, 0x00, 
        0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x18, 0x30, 
        0x0E, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0E, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x7E, 0x00, 0x00, 0x00, 
        0x70, 0x18, 0x0C, 0x06, 0x0C, 0x18, 0x70, 0x00, 0x3C, 0x66, 0x06, 0x0C, 0x18, 0x00, 0x18, 0x00, 
        0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x08, 0x1C, 0x3E, 0x7F, 0x7F, 0x1C, 0x3E, 0x00, 
        0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0xE0, 0xF0, 0x38, 0x18, 0x18, 
        0x18, 0x18, 0x1C, 0x0F, 0x07, 0x00, 0x00, 0x00, 0x18, 0x18, 0x38, 0xF0, 0xE0, 0x00, 0x00, 0x00, 
        0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xFF, 0xFF, 0xC0, 0xE0, 0x70, 0x38, 0x1C, 0x0E, 0x07, 0x03, 
        0x03, 0x07, 0x0E, 0x1C, 0x38, 0x70, 0xE0, 0xC0, 0xFF, 0xFF, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 
        0xFF, 0xFF, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00, 0x3C, 0x7E, 0x7E, 0x7E, 0x7E, 0x3C, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x36, 0x7F, 0x7F, 0x7F, 0x3E, 0x1C, 0x08, 0x00, 
        0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x07, 0x0F, 0x1C, 0x18, 0x18, 
        0xC3, 0xE7, 0x7E, 0x3C, 0x3C, 0x7E, 0xE7, 0xC3, 0x00, 0x3C, 0x7E, 0x66, 0x66, 0x7E, 0x3C, 0x00, 
        0x18, 0x18, 0x66, 0x66, 0x18, 0x18, 0x3C, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x08, 0x1C, 0x3E, 0x7F, 0x3E, 0x1C, 0x08, 0x00, 0x18, 0x18, 0x18, 0xFF, 0xFF, 0x18, 0x18, 0x18, 
        0xC0, 0xC0, 0x30, 0x30, 0xC0, 0xC0, 0x30, 0x30, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 
        0x00, 0x00, 0x03, 0x3E, 0x76, 0x36, 0x36, 0x00, 0xFF, 0x7F, 0x3F, 0x1F, 0x0F, 0x07, 0x03, 0x01, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 
        0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 
        0xCC, 0xCC, 0x33, 0x33, 0xCC, 0xCC, 0x33, 0x33, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x00, 0x00, 0x00, 0x00, 0xCC, 0xCC, 0x33, 0x33, 0xFF, 0xFE, 0xFC, 0xF8, 0xF0, 0xE0, 0xC0, 0x80, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x18, 0x18, 0x18, 0x1F, 0x1F, 0x18, 0x18, 0x18, 
        0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0F, 0x18, 0x18, 0x18, 0x1F, 0x1F, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0xF8, 0xF8, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 
        0x00, 0x00, 0x00, 0x1F, 0x1F, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xFF, 0xFF, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0xFF, 0xFF, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xF8, 0xF8, 0x18, 0x18, 0x18, 
        0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xF0, 0xF0, 0xF0, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0xF8, 0xF8, 0x00, 0x00, 0x00, 
        0xF0, 0xF0, 0xF0, 0xF0, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xF0, 0xF0, 0xF0, 0x0F, 0x0F, 0x0F, 0x0F
};
static unsigned char *charset = 0;

static void FreeCharset(void)
{
	if (charset) {
		delete[] charset;
		charset = 0;
	}
}

static void LoadCharset(int chrs)
{
	unsigned long i;
	unsigned char *csrc;

	csrc = prechr;
	if (chrs == CHARSET_ATARI) csrc = prechratari;

	FreeCharset();
	charset = new unsigned char[0x0800];
	for (i=0;i<0x0400;i++)
	{
		charset[i] = csrc[i];
		charset[i+0x0400] = ~csrc[i];
	}

	// inverted '@' has one pixel difference to normal '@':
	if (chrs == CHARSET_COMMODORE) charset[0x0405] = 0x99;
}

/************************************************************************/

void CbmList::Init(int charset)
{
	screen = 0;
	screenlines = 0;
	linesize = 32;

	LoadCharset(charset);
}

void CbmList::Exit()
{
	if (screen)
	{
		delete[] screen;
		screen = 0;
	}

	FreeCharset();
}

void CbmList::Add(unsigned char *line)
{
	unsigned long i, c;
	unsigned char *ns;

	c = screenlines*linesize;
	ns = new unsigned char[c+linesize];
	if (screen)
	{
		for (i=0;i<c;i++) ns[i] = screen[i];
		delete[] screen;
	}
	screen = ns;
	for (i=0;i<linesize;i++) screen[c+i] = line[i];
	screenlines++;
}

CbmBitmap *CbmList::GetBitmap()
{
	unsigned long x, y;
	unsigned char *scr;
	CbmBitmap *bm;

	bm = new CbmBitmap;

	bm->Init(linesize, screenlines);

	scr = screen;
	for (y=0;y<screenlines;y++)
	{
		for (x=0;x<linesize;x++)
		{
			bm->Draw(*scr, x, y);
			scr++;
		}
	}
	return bm;
}

char ConvertToPETSCII(unsigned char c)
{
	unsigned char conv[4] = { 0x40, 0x20, 0x60, 0x60 };

	c &= 0x7F;

	switch (c)
	{
	case (0x5D):
	case (0x61):
	case (0x75):
	case (0x76):
		return ('|');
	case (0x40):
//	case (0x43):
	case (0x62):
	case (0x78):
	case (0x79):
		return ('-');
	case (0x64):
	case (0x6F):
		return ('_');
	case (0x63):
	case (0x77):
		return ('');
	case (0x1C):
		return ('');
//	case (0x56):
//		return ('');
	case (0x1E):
		return ('^');
	case (0x1F):
		return ('');
//	case (0x4E):
//		return ('/');
//	case (0x4D):
//		return ('\\');
//	case (0x49):
//	case (0x4A):
//	case (0x4B):
//	case (0x55):
	case (0x5B):
	case (0x6B):
	case (0x6C):
	case (0x6D):
	case (0x6E):
	case (0x70):
	case (0x71):
	case (0x72):
	case (0x73):
	case (0x7B):
	case (0x7C):
	case (0x7D):
	case (0x7E):
	case (0x7F):
		return ('+');
	}

	c = conv[(c >> 5)] | (c & 0x1F);

	return ((char)c);
}

char *CbmList::GetASCII()
{
	unsigned long x, y, i, ls;
	unsigned char *scr;
	unsigned char c;
	char *ascii;

	ascii = new char[(linesize*screenlines)+1+screenlines];
	i = 0;
	for (y=0;y<screenlines;y++)
	{
		scr = &screen[y*linesize];

		ls = linesize;
		while (ls > 0) {
			if (scr[ls-1] != 0x20) break;
			ls--;
		}

		for (x=0;x<ls;x++)
		{
			c = ConvertToPETSCII(scr[x]);
			if (c < 0x20) c = 0x20;
			ascii[i] = c;
			i++;
		}
		ascii[i] = 0x0A;
		i++;
	}

	ascii[i] = 0;

	return ascii;
}

/************************************************************************/

void CbmBitmap::Init(unsigned long lsize, unsigned long lines)
{
	unsigned long i;

	screenlines = lines;
	linesize = lsize;
	bitmap = new unsigned char[screenlines*(linesize<<3)];
	for (i=0;i<(screenlines*(linesize<<3));i++) bitmap[i] = 0;
//	LoadCharset();
}

void CbmBitmap::Exit()
{
	if (bitmap)
	{
		delete[] bitmap;
		bitmap = 0;
	}
}

void CbmBitmap::Draw(unsigned char chr, unsigned long x, unsigned long y)
{
	unsigned long i;
	unsigned char *current;
	unsigned char *scrnchr;

	current = &charset[((unsigned long)chr) << 3];
	scrnchr = &bitmap[(y*linesize<<3)+x];

	for (i=0;i<8;i++)
	{
		*scrnchr = *current++;
		scrnchr += linesize;
	}
}

unsigned char CbmBitmap::GetPixel(unsigned long x, unsigned long y)
{
	if (x >= (linesize<<3)) return 0;
	if (y >= (screenlines<<3)) return 0;

	x ^= 7;

	return (bitmap[(y*linesize)+(x>>3)] & (1 << (x & 7)));
}

unsigned long CbmBitmap::GetWidth()
{
	return (linesize << 3);
}

unsigned long CbmBitmap::GetHeight()
{
	return (screenlines << 3);
}
