#ifndef ___D64_H___
#define ___D64_H___

#include "FileImage.h"

#define D64STRATEGY_CLOSEST		0	// file save strategy: store files close to track 18 first
#define D64STRATEGY_LINEAR		1	// fils save strategy: start at track 1
#define D64STRATEGY_SUBLINEAR	2	// file save strategy: lower tracks first and close to track 18 first

extern void initd64(void);

class FileD64 : public FileImage
{
private:
	class ImageMap *map; /* for traversing files */

	unsigned char GetMaxSectors(short track);

	unsigned short WriteData(unsigned char *data, unsigned long size);
	bool WriteFile(SP<ByteBuffer> name, unsigned char type, unsigned char *data, unsigned long size);

	void ClearBAM(void);
	bool IsValidBlock(short track, short sector);
	bool IsFreeBlock(short track, short sector);
	void AllocBlock(short track, short sector);
	void FreeBlock(short track, short sector);

	bool AlreadyVisited(short track, short sector);
	void SetVisitedFlag(short track, short sector);
	long GetBlockOffset(short track, short sector);
	unsigned char *GetBlock(short track, short sector);
	unsigned char *GetHeaderBlock(void);

	short AllocNextBlockOnTrack(short track, short sector, short interleave);
	unsigned short AllocFirstBlock(void);
	unsigned short AllocNextBlockSide1(short track, short sector, short interleave);
	unsigned short AllocNextBlockSide2(short track, short sector, short interleave);
	unsigned short AllocNextBlock(short track, short sector, short interleave);

	void ValidateLinks(short track, short sector);
	long GetFileLinks(short track, short sector, unsigned char *buffer);
	long GetFileLength(short track, short sector);

	void TestDirectory(void);
	unsigned char *GetEmptyDirEntry(void);
	unsigned char *AddDirBlock(void);

	unsigned char *GetFileData(short track, short sector);

	bool InitZipCode(SP<StringStream> filename);
	bool ParseZipCode(unsigned char *data, unsigned long size, short mintrack, short maxtrack);

	void InitMap(void);
	void ClearMap(void);

	void SetErrorCode(short track, short sector, unsigned char error);

protected:
	void Init(int type);

public:
	FileD64(void);
	FileD64(int type);
	FileD64(const class ByteBuffer *buffer);
	~FileD64(void);

	void Init(SP<StringStream> path, const unsigned char *data, int size);
	class FileImage *Clone(void);

	void SetHeader(SP<ByteBuffer> header);
	bool HasHeader(void);
	int GetImageSystem(void);

	void Validate(void);
	bool AddSeperator(void);
	bool WriteFile(class C64File *file);
	void ScratchFile(unsigned long index);
	C64File *GetFile(unsigned long index);
	struct CbmList *GetDirectory(void);

	void Save(const char *filename);
	SP<StringStream> SaveFile(SP<StringStream> temppath, unsigned long index);

	unsigned char *GetDirEntry(unsigned long index);
	void SwapDirEntries(unsigned long index1, unsigned long index2);
	unsigned char *GetHeader(void);
};

FileD64 *CreateD64(SP<StringStream> path, int type, const unsigned char *data, int size);

#endif
