#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
#include <stdio.h>
#include <windows.h>

void sDPrint(const char *x)
{
  OutputDebugString(x);
}

/************************************************************************/

void sSPrintF(char *buffer,int size,char *format,...)
{
  va_list va;

  va_start(va,format);

  _vsnprintf(buffer,size,format,va);

  va_end(va);
}

/************************************************************************/

void sDPrintF(char *format,...)
{
  char buffer[256];

  va_list va;

  va_start(va,format);

  _vsnprintf(buffer,sizeof(buffer),format,va);
  sDPrint(buffer);

  va_end(va);
}

/************************************************************************/

void sPrintF(char *format,...)
{
  char buffer[256];

  va_list va;

  va_start(va,format);

  vprintf(format,va);
  _vsnprintf(buffer,sizeof(buffer),format,va);
  sDPrint(buffer);

  va_end(va);
}

/************************************************************************/

void sPrint(char *x)
{
  printf("%s",x);
  sDPrint(x);
}

/************************************************************************/

