#include "d64.h"
#include "petscii.h"
#include "window.h"
#include "netarc.h"
#include "FileImage.h"
#include "GlobalConfig.h"
#include "files.h"
#include "debug.h"
#include "StringStream.h"
#include "SmartPointer.h"
#include <time.h>

#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
//#include <olestd.h>
#include <crtdbg.h>       // MSVC function: _CrtDumpMemoryLeaks

unsigned short crc16(unsigned short crc, const unsigned char *data, int size)
{
	int i, k;

	for (k=0;k<size;k++) {

		crc ^= data[k];
		for (i=0;i<8;i++)
		{
			if (crc & 1) {
				crc >>= 1;
				crc ^= 0xA001;
			} else {
				crc >>= 1;
			}
		}
	}

	return crc;
}

unsigned int crc32(unsigned int crc, const unsigned char* data, int size)
{
	int i, k;

	crc = ~crc;
	for (k=0;k<size;k++) {

		crc ^= data[k];
		for (i=0;i<8;i++) {
			if (crc & 1) {
				crc >>= 1;
				crc ^= 0xEDB88320;
			} else {
				crc >>= 1;
			}
		}
	}

	return (~crc);
}

// 0xCBF43926

int WINAPI SubWinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd)
{
	CbmWindow *cw;
	NetArc net;
	MSG msg;
	SP<FileImage> fd64;
	GlobalConfig *config;
	char *cfgpath;
	char *newpath;
	SP<StringStream> cfgname;

	srand(time(NULL));

	cfgpath = new char[MAX_PATH];
	GetModuleFileName(hInstance, cfgpath, MAX_PATH);
	cfgname = getfilepath(new StringStream(cfgpath), "arc64.cfg");
	newpath = cfgname->GetString();
	delete[] cfgpath;

	config = new GlobalConfig(cfgname);
	Config = config;

	initpetscii();
	initd64();

	fd64 = config->Load();
	fd64 = config->ParseCmds(fd64, lpCmdLine);

	OleInitialize(0);

	net.Init(config->GetIP()->GetString(), config->GetNetPort());

	cw = new CbmWindow();
	cw->Init(hInstance, &net);
	cw->Show(fd64);

	while (GetMessage(&msg, NULL, 0, 0)) {
		TranslateMessage(&msg);
		 DispatchMessage(&msg);
		WaitMessage();
	}
	cw->Exit();
	delete cw;
	net.Exit();

	OleUninitialize();

	exitpetscii();

	delete config;

	return 0;
}

// WinMain wrapper, otherwise CrtDumpMemoryLeaks will dump some SmartPointer objects
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd)
{
	SubWinMain(hInstance, hPrevInstance, lpCmdLine, nShowCmd);

#ifdef _DEBUG
	_CrtDumpMemoryLeaks();
#endif

	return 0;
}
