#include "nethost.h"

void NetSocket::Init(void)
{
	Socket = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
}

void NetSocket::Exit(void)
{
	if (Socket) {
#ifdef WIN32
		closesocket(Socket);
#else
		close(Socket);
#endif
		Socket = INVALID_SOCKET;
	}
}

SOCKET NetSocket::GetSocket(void) const
{
	return Socket;
}

void NetHost::Init(const NetSocket *sock, const char *addr, uWORD prt)
{
	uLONG i;

	for (i=0;i<sizeof(Address);i++) ((uBYTE *)(&Address))[i] = 0;

	Socket = sock->GetSocket();
	Address.sin_addr.s_addr = inet_addr(addr);	// cast to uchar*
	Address.sin_family = AF_INET;
	Address.sin_port = htons(prt);
}

void NetHost::Exit(void)
{
}

int NetHost::Send(uBYTE *buf, uLONG size)
{
	int error;

	error = sendto(Socket, (char *)buf, size, 0, (sockaddr *)(&Address), sizeof(Address));
	
	return (error != SOCKET_ERROR);
}

int NetHost::Recv(uBYTE *buf, uLONG size, uLONG timeout)
{
	fd_set sockset;
	timeval tv;
	socklen_t addrrecvsize;
	SOCKADDR_IN addrrecv;
	int error;
	uLONG i;

	for (i=0;i<sizeof(addrrecv);i++) ((char *)&addrrecv)[i] = 0;
	addrrecvsize = sizeof(addrrecv);
	FD_ZERO(&sockset);
	FD_SET(Socket, &sockset);
	tv.tv_sec = timeout / 1000;
	tv.tv_usec = (timeout % 1000) * 1000;

	error = select(Socket+1, &sockset, 0, 0, &tv);
	if (error > 0) {
		error = recvfrom(Socket, (char *)buf, size, 0, (sockaddr *)(&addrrecv), &addrrecvsize);
		if (error != SOCKET_ERROR) return NETHOST_OK;
	} else {
		return NETHOST_TIMEOUT;
	}

	return NETHOST_ERROR;
}
